/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle.info;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

public interface NodeInfo {
    default public boolean zeroWeight() {
        return this.weight() == 0L;
    }

    public long nodeId();

    public AccountID accountId();

    public long weight();

    public Bytes sigCertBytes();

    public List<ServiceEndpoint> gossipEndpoints();

    @NonNull
    public List<ServiceEndpoint> hapiEndpoints();

    public boolean declineReward();

    default public X509Certificate sigCert() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.sigCertBytes().toByteArray()));
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Error extracting public key from certificate", e);
        }
    }

    @Nullable
    default public Bytes grpcCertHash() {
        return null;
    }
}

