/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.common.utility.throttle.RateLimiter;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateHistory;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;

public class DefaultSignedStateSentinel
implements SignedStateSentinel {
    private static final Logger logger = LogManager.getLogger(DefaultSignedStateSentinel.class);
    private final Time time;
    private final RateLimiter rateLimiter;
    private final Duration maxSignedStateAge;

    public DefaultSignedStateSentinel(@NonNull PlatformContext platformContext) {
        this.time = platformContext.getTime();
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        this.maxSignedStateAge = stateConfig.suspiciousSignedStateAge();
        Duration rateLimitPeriod = stateConfig.signedStateAgeNotifyRateLimit();
        this.rateLimiter = new RateLimiter(Time.getCurrent(), rateLimitPeriod);
    }

    @Override
    public void checkSignedStates(@NonNull Instant now) {
        if (!this.rateLimiter.request()) {
            return;
        }
        RuntimeObjectRecord objectRecord = RuntimeObjectRegistry.getOldestActiveObjectRecord(SignedState.class);
        if (objectRecord == null) {
            return;
        }
        if (CompareTo.isGreaterThan((Comparable)objectRecord.getAge(this.time.now()), (Object)this.maxSignedStateAge) && this.rateLimiter.requestAndTrigger()) {
            SignedStateHistory history = (SignedStateHistory)objectRecord.getMetadata();
            logger.error(LogMarker.EXCEPTION.getMarker(), "Old signed state detected. The most likely causes are either that the node has gotten stuck or that there has been a memory leak.\n{}", (Object)history);
        }
    }
}

