/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.transformers;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.transformers.RoutableData;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

public class WireRouter<ROUTER_TYPE extends Enum<ROUTER_TYPE>> {
    private final BindableInputWire<RoutableData<ROUTER_TYPE>, Void> inputWire;
    private final List<StandardOutputWire<Object>> outputWires;
    private final Class<ROUTER_TYPE> clazz;

    public WireRouter(@NonNull WiringModel model, @NonNull String routerName, @NonNull String routerInputName, @NonNull Class<ROUTER_TYPE> clazz) {
        TaskScheduler scheduler = model.schedulerBuilder(routerName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.outputWires = new ArrayList<StandardOutputWire<Object>>(((Enum[])clazz.getEnumConstants()).length);
        for (int index = 0; index < ((Enum[])clazz.getEnumConstants()).length; ++index) {
            Enum dataType = ((Enum[])clazz.getEnumConstants())[index];
            if (dataType.ordinal() != index) {
                throw new IllegalArgumentException("Enum values must be in order");
            }
            StandardOutputWire outputWire = scheduler.buildSecondaryOutputWire();
            this.outputWires.add(outputWire);
        }
        this.inputWire = scheduler.buildInputWire(routerInputName);
        this.inputWire.bindConsumer(this::routeData);
        this.clazz = clazz;
    }

    @NonNull
    public InputWire<RoutableData<ROUTER_TYPE>> getInput() {
        return this.inputWire;
    }

    @NonNull
    public <OUTPUT_TYPE> OutputWire<OUTPUT_TYPE> getOutput(@NonNull ROUTER_TYPE address) {
        return this.outputWires.get(((Enum)address).ordinal());
    }

    @NonNull
    public Class<ROUTER_TYPE> getRouterType() {
        return this.clazz;
    }

    private void routeData(@NonNull RoutableData<ROUTER_TYPE> routableData) {
        ROUTER_TYPE dataType = routableData.address();
        StandardOutputWire<Object> outputWire = this.outputWires.get(((Enum)dataType).ordinal());
        outputWire.forward(routableData.data());
    }
}

