/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.util;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPerformanceTest {
    private static final Logger logger = LogManager.getLogger(AbstractPerformanceTest.class);

    protected void measure(Consumer<Void> methodToMeasure, Consumer<Void> prepareMethod, int numberOfTimesToExecute, String measureName) {
        if (numberOfTimesToExecute < 3) {
            throw new IllegalArgumentException("Number of times to execute must be at least 3: " + numberOfTimesToExecute);
        }
        long[] runningTimes = new long[numberOfTimesToExecute];
        for (int index = 0; index < numberOfTimesToExecute; ++index) {
            prepareMethod.accept(null);
            long start = System.currentTimeMillis();
            methodToMeasure.accept(null);
            long end = System.currentTimeMillis();
            runningTimes[index] = end - start;
        }
        Arrays.sort(runningTimes);
        long sum = 0L;
        long limit = numberOfTimesToExecute - 1;
        int index = 1;
        while ((long)index < limit) {
            sum += runningTimes[index];
            ++index;
        }
        long average = sum / (long)(numberOfTimesToExecute - 2);
        logger.info("The test {} took on average {}, with min {} and max {}", (Object)measureName, (Object)average, (Object)runningTimes[1], (Object)runningTimes[runningTimes.length - 2]);
    }
}

