/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.proof.algorithms;

import com.swirlds.common.io.extendable.ExtendableInputStream;
import com.swirlds.common.io.extendable.ExtendableOutputStream;
import com.swirlds.common.io.extendable.InputStreamExtension;
import com.swirlds.common.io.extendable.OutputStreamExtension;
import com.swirlds.common.io.extendable.extensions.MaxSizeStreamExtension;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.platform.proof.algorithms.NodeSignature;
import com.swirlds.platform.proof.algorithms.StateProofConstants;
import com.swirlds.platform.proof.tree.StateProofInternalNode;
import com.swirlds.platform.proof.tree.StateProofNode;
import com.swirlds.platform.proof.tree.StateProofPayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.hiero.base.crypto.Signature;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;

public final class StateProofSerialization {
    private StateProofSerialization() {
    }

    public static void serializeSignatures(@NonNull SerializableDataOutputStream out, @NonNull List<NodeSignature> signatures) throws IOException {
        if (signatures.size() > 1024) {
            throw new IOException("too many signatures: " + signatures.size() + ", limit: 1024");
        }
        out.writeInt(signatures.size());
        for (NodeSignature entry : signatures) {
            out.writeSerializable((SelfSerializable)entry.nodeId(), false);
            entry.signature().serialize(out, false);
        }
    }

    @NonNull
    public static List<NodeSignature> deserializeSignatures(@NonNull SerializableDataInputStream in) throws IOException {
        int numSignatures = in.readInt();
        if (numSignatures > 1024) {
            throw new IOException("too many signatures: " + numSignatures + ", limit: 1024");
        }
        ArrayList<NodeSignature> signatures = new ArrayList<NodeSignature>();
        for (int i = 0; i < numSignatures; ++i) {
            NodeId nodeId = (NodeId)in.readSerializable(false, NodeId::new);
            if (nodeId == null) {
                throw new IOException("nodeId is null");
            }
            Signature signature = Signature.deserialize((SerializableDataInputStream)in, (boolean)false);
            signatures.add(new NodeSignature(nodeId, signature));
        }
        return signatures;
    }

    public static void serializeStateProofTree(@NonNull SerializableDataOutputStream out, @NonNull StateProofNode root) throws IOException {
        SerializableDataOutputStream limitedStream = new SerializableDataOutputStream((OutputStream)new ExtendableOutputStream((OutputStream)out, (OutputStreamExtension)new MaxSizeStreamExtension(StateProofConstants.MAX_STATE_PROOF_TREE_SIZE, false)));
        LinkedList<StateProofNode> queue = new LinkedList<StateProofNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            StateProofNode next = (StateProofNode)queue.remove();
            if (next instanceof StateProofInternalNode) {
                StateProofInternalNode internal = (StateProofInternalNode)next;
                limitedStream.writeBoolean(true);
                if (internal.getChildren().size() > 64) {
                    throw new IOException("too many children: " + internal.getChildren().size() + ", limit: 64");
                }
                limitedStream.writeInt(internal.getChildren().size());
                queue.addAll(internal.getChildren());
                continue;
            }
            limitedStream.writeBoolean(false);
            limitedStream.writeSerializable((SelfSerializable)next, true);
        }
    }

    private static void addToParent(@NonNull Queue<ParentAwaitingChildren> queue, @NonNull StateProofNode child) throws IOException {
        if (queue.isEmpty()) {
            throw new IOException("No parent awaiting children");
        }
        ParentAwaitingChildren parent = queue.peek();
        parent.parent.getChildren().add(child);
        if (parent.parent.getChildren().size() == parent.expectedChildCount) {
            queue.remove();
        }
    }

    @NonNull
    public static StateProofNode deserializeStateProofTree(@NonNull SerializableDataInputStream in) throws IOException {
        SerializableDataInputStream limitedStream = new SerializableDataInputStream((InputStream)new ExtendableInputStream((InputStream)in, (InputStreamExtension)new MaxSizeStreamExtension(StateProofConstants.MAX_STATE_PROOF_TREE_SIZE, false)));
        LinkedList<ParentAwaitingChildren> queue = new LinkedList<ParentAwaitingChildren>();
        boolean firstNode = true;
        StateProofNode root = null;
        while (!queue.isEmpty() || firstNode) {
            StateProofNode next;
            boolean isInternal = limitedStream.readBoolean();
            if (isInternal) {
                int childCount;
                next = new StateProofInternalNode();
                if (!firstNode) {
                    StateProofSerialization.addToParent(queue, next);
                }
                if ((childCount = limitedStream.readInt()) > 64) {
                    throw new IOException("Child count exceeds maximum allowed value of 64");
                }
                queue.add(new ParentAwaitingChildren((StateProofInternalNode)next, childCount));
            } else {
                next = (StateProofNode)limitedStream.readSerializable();
                if (!firstNode) {
                    StateProofSerialization.addToParent(queue, next);
                }
            }
            if (!firstNode) continue;
            root = next;
            firstNode = false;
        }
        if (root == null) {
            throw new IOException("Failed to find root");
        }
        return root;
    }

    @NonNull
    public static List<MerkleLeaf> extractPayloads(@NonNull StateProofNode root) throws IOException {
        ArrayList<MerkleLeaf> payloads = new ArrayList<MerkleLeaf>();
        LinkedList<StateProofNode> queue = new LinkedList<StateProofNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            StateProofNode next = (StateProofNode)queue.remove();
            if (next instanceof StateProofPayload) {
                StateProofPayload payload = (StateProofPayload)next;
                payloads.add(payload.getPayload());
                continue;
            }
            if (!(next instanceof StateProofInternalNode)) continue;
            StateProofInternalNode internal = (StateProofInternalNode)next;
            queue.addAll(internal.getChildren());
        }
        if (payloads.isEmpty()) {
            throw new IOException("No payloads found");
        }
        return payloads;
    }

    private record ParentAwaitingChildren(@NonNull StateProofInternalNode parent, int expectedChildCount) {
    }
}

