/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.FilteredReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class FilteredWritableStates
extends FilteredReadableStates
implements WritableStates {
    private final WritableStates delegate;

    public FilteredWritableStates(@NonNull WritableStates delegate, @NonNull Set<String> stateKeys) {
        super(delegate, stateKeys);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    @NonNull
    public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find k/v state " + stateKey);
        }
        return this.delegate.get(stateKey);
    }

    @Override
    @NonNull
    public <T> WritableSingletonState<T> getSingleton(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find singleton state " + stateKey);
        }
        return this.delegate.getSingleton(stateKey);
    }

    @Override
    @NonNull
    public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        if (!this.contains(stateKey)) {
            throw new IllegalArgumentException("Could not find queue state " + stateKey);
        }
        return this.delegate.getQueue(stateKey);
    }

    public WritableStates getDelegate() {
        return this.delegate;
    }
}

