/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.reconnect.ReconnectLearner;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public class ReconnectLearnerFactory {
    private final Roster roster;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics statistics;
    private final ThreadManager threadManager;
    private final PlatformContext platformContext;
    private final PlatformStateFacade platformStateFacade;
    private final Function<VirtualMap, MerkleNodeState> stateRootFunction;

    public ReconnectLearnerFactory(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull Roster roster, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics statistics, @NonNull PlatformStateFacade platformStateFacade, @NonNull Function<VirtualMap, MerkleNodeState> stateRootFunction) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.roster = Objects.requireNonNull(roster);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.statistics = Objects.requireNonNull(statistics);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        this.stateRootFunction = Objects.requireNonNull(stateRootFunction);
    }

    public ReconnectLearner create(Connection conn, MerkleNodeState workingState) {
        return new ReconnectLearner(this.platformContext, this.threadManager, conn, this.roster, workingState, this.reconnectSocketTimeout, this.statistics, this.platformStateFacade, this.stateRootFunction);
    }
}

