/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.signed.SignedState;
import java.io.File;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RuntimeMetrics {
    private static final double WHOLE_PERCENT = 100.0;
    private static final File ROOT_DIRECTORY = new File("/");
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
    private static final FunctionGauge.Config<String> TIMESTAMP_CONFIG = new FunctionGauge.Config("platform:info", "time", String.class, () -> DATE_TIME_FORMATTER.format(Instant.now().atZone(UTC))).withDescription("the current time").withFormat("%25s");
    private static final RunningAverageMetric.Config MEM_FREE_CONFIG = new RunningAverageMetric.Config("platform", "memFree").withDescription("bytes of free memory (which can increase after a garbage collection)").withFormat("%,16.0f").withHalfLife(0.0);
    private final RunningAverageMetric memFree;
    private static final RunningAverageMetric.Config MEM_TOT_CONFIG = new RunningAverageMetric.Config("platform", "memTot").withDescription("total bytes in the Java Virtual Machine").withFormat("%,16.0f").withHalfLife(0.0);
    private final RunningAverageMetric memTot;
    private static final RunningAverageMetric.Config MEM_MAX_CONFIG = new RunningAverageMetric.Config("platform", "memMax").withDescription("maximum bytes that the JVM might use").withFormat("%,16.0f").withHalfLife(0.0);
    private final RunningAverageMetric memMax;
    private static final RunningAverageMetric.Config DIRECT_MEM_IN_MB_CONFIG = new RunningAverageMetric.Config("platform", "directMemInMB").withDescription("megabytes of off-heap (direct) memory being used by the JVM").withFormat("%,16.2f").withHalfLife(0.0);
    private final RunningAverageMetric directMemInMB;
    private static final RunningAverageMetric.Config DIRECT_MEM_PERCENT_CONFIG = new RunningAverageMetric.Config("platform", "directMemPercent").withDescription("off-heap (direct) memory used, as a percent of MaxDirectMemorySize").withFormat("%,16.2f").withHalfLife(0.0);
    private final RunningAverageMetric directMemPercent;
    private static final RunningAverageMetric.Config AVG_NUM_PROC_CONFIG = new RunningAverageMetric.Config("platform", "proc").withDescription("number of processors (cores) available to the JVM").withFormat("%,8.0f");
    private final RunningAverageMetric avgNumProc;
    private static final RunningAverageMetric.Config CPU_LOAD_SYS_CONFIG = new RunningAverageMetric.Config("platform", "cpuLoadSys").withDescription("the CPU load of the whole system").withFormat("%,1.4f");
    private final RunningAverageMetric cpuLoadSys;
    private static final RunningAverageMetric.Config THREADS_CONFIG = new RunningAverageMetric.Config("platform", "threads").withDescription("the current number of live threads").withFormat("%,6.0f");
    private final RunningAverageMetric threads;
    private static final FunctionGauge.Config<Long> DISKSPACE_FREE_CONFIG = new FunctionGauge.Config("internal", "DiskspaceFree", Long.class, ROOT_DIRECTORY::getFreeSpace).withDescription("disk space being used right now").withFormat("%d");
    private static final FunctionGauge.Config<Long> DISKSPACE_WHOLE_CONFIG = new FunctionGauge.Config("internal", "DiskspaceWhole", Long.class, ROOT_DIRECTORY::getTotalSpace).withDescription("total disk space available on node").withFormat("%d");
    private static final FunctionGauge.Config<Long> DISKSPACE_USED_CONFIG = new FunctionGauge.Config("internal", "DiskspaceUsed", Long.class, () -> ROOT_DIRECTORY.getTotalSpace() - ROOT_DIRECTORY.getFreeSpace()).withDescription("disk space free for use by the node").withFormat("%d");
    private final OperatingSystemMXBean osBean;
    private final ThreadMXBean thbean;
    private final BufferPoolMXBean directMemMXBean;
    private final double maximumDirectMemSizeInMB;
    private static final AtomicBoolean SETUP_STARTED = new AtomicBoolean();

    public static void setup(Metrics metrics) {
        if (SETUP_STARTED.compareAndSet(false, true)) {
            RuntimeMetrics runtimeMetrics = new RuntimeMetrics(metrics);
            metrics.addUpdater(runtimeMetrics::update);
        }
    }

    private RuntimeMetrics(Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.thbean = ManagementFactory.getThreadMXBean();
        this.directMemMXBean = RuntimeMetrics.getDirectMemMXBean();
        this.maximumDirectMemSizeInMB = RuntimeMetrics.getMaximumDirectMemSizeInMB();
        metrics.getOrCreate(TIMESTAMP_CONFIG);
        this.memFree = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MEM_FREE_CONFIG);
        this.memTot = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MEM_TOT_CONFIG);
        this.memMax = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MEM_MAX_CONFIG);
        this.directMemInMB = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)DIRECT_MEM_IN_MB_CONFIG);
        this.directMemPercent = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)DIRECT_MEM_PERCENT_CONFIG);
        this.avgNumProc = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_NUM_PROC_CONFIG);
        this.cpuLoadSys = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)CPU_LOAD_SYS_CONFIG);
        this.threads = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)THREADS_CONFIG);
        metrics.getOrCreate(DISKSPACE_FREE_CONFIG);
        metrics.getOrCreate(DISKSPACE_WHOLE_CONFIG);
        metrics.getOrCreate(DISKSPACE_USED_CONFIG);
        RuntimeObjectRegistry.createRecord(SignedState.class).release();
        for (Class cls : RuntimeObjectRegistry.getTrackedClasses()) {
            String className = cls.getSimpleName();
            metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "countInMemory" + className, Integer.class, () -> RuntimeObjectRegistry.getActiveObjectsCount((Class)cls)).withDescription("the number of " + className + " objects in memory").withFormat("%d"));
            metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "oldest" + className + "Seconds", Long.class, () -> RuntimeObjectRegistry.getOldestActiveObjectAge((Class)cls, (Instant)Instant.now()).toSeconds()).withDescription("the age of the oldest " + className + " object in memory").withFormat("%d"));
        }
    }

    private static BufferPoolMXBean getDirectMemMXBean() {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : pools) {
            if (!pool.getName().equals("direct")) continue;
            return pool;
        }
        return null;
    }

    private static double getMaximumDirectMemSizeInMB() {
        HotSpotDiagnosticMXBean hsdiag = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        long maxDirectMemoryInBytes = Runtime.getRuntime().maxMemory();
        if (hsdiag != null) {
            try {
                long value = Long.parseLong(hsdiag.getVMOption("MaxDirectMemorySize").getValue());
                if (value > 0L) {
                    maxDirectMemoryInBytes = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (double)maxDirectMemoryInBytes * 9.5367431640625E-7;
    }

    private void update() {
        this.memFree.update((double)Runtime.getRuntime().freeMemory());
        this.memTot.update((double)Runtime.getRuntime().totalMemory());
        this.memMax.update((double)Runtime.getRuntime().maxMemory());
        this.avgNumProc.update((double)Runtime.getRuntime().availableProcessors());
        this.cpuLoadSys.update(this.osBean.getCpuLoad());
        this.threads.update((double)this.thbean.getThreadCount());
        if (this.directMemMXBean == null) {
            return;
        }
        long bytesUsed = this.directMemMXBean.getMemoryUsed();
        if (bytesUsed == -1L) {
            this.directMemInMB.update((double)bytesUsed);
            if (this.maximumDirectMemSizeInMB > 0.0) {
                this.directMemPercent.update((double)bytesUsed);
            }
            return;
        }
        double megabytesUsed = (double)bytesUsed * 9.5367431640625E-7;
        this.directMemInMB.update(megabytesUsed);
        if (this.maximumDirectMemSizeInMB > 0.0) {
            this.directMemPercent.update(megabytesUsed * 100.0 / this.maximumDirectMemSizeInMB);
        }
    }
}

