/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;

public class TapCharIterable
extends AbstractLazyCharIterable {
    private final CharIterable adapted;
    private final CharProcedure procedure;

    public TapCharIterable(CharIterable delegate, CharProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    public void each(CharProcedure procedure) {
        this.adapted.forEach((CharProcedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.adapted.anySatisfy((CharPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.adapted.allSatisfy((CharPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.adapted.noneSatisfy((CharPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.adapted.detectIfNone((CharPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    public CharIterator charIterator() {
        return new TapCharIterator(this.adapted, this.procedure);
    }

    public static class TapCharIterator
    implements CharIterator {
        private final CharIterator iterator;
        private final CharProcedure procedure;

        public TapCharIterator(CharIterable iterable, CharProcedure procedure) {
            this(iterable.charIterator(), procedure);
        }

        public TapCharIterator(CharIterator iterator, CharProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public char next() {
            char next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

