/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.validators;

import com.swirlds.config.api.validation.ConfigPropertyConstraint;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.api.validation.PropertyMetadata;
import com.swirlds.config.impl.validators.DefaultConfigViolation;
import java.util.Objects;

public class MinLengthConstraint
implements ConfigPropertyConstraint<String> {
    private final int minLength;

    public MinLengthConstraint(int minLength) {
        this.minLength = minLength;
    }

    public ConfigViolation check(PropertyMetadata<String> metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        if (!metadata.exists()) {
            String message = "Property '" + metadata.getName() + "' must be defined";
            return DefaultConfigViolation.of(metadata, message);
        }
        if (metadata.getRawValue() == null) {
            String message = "Property '" + metadata.getName() + "' must not be null.";
            return DefaultConfigViolation.of(metadata, message);
        }
        int valueLength = metadata.getRawValue().length();
        if (valueLength < this.minLength) {
            String message = "String value of Property '" + metadata.getName() + "' must have a minimum length of '" + this.minLength + "'";
            return DefaultConfigViolation.of(metadata, message);
        }
        return null;
    }
}

