/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.transaction.pool;

import com.swirlds.base.utility.Pair;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.HotspotConfiguration;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.time.Instant;
import java.util.ArrayList;

class AccountTransactionFactory {
    private final PTTRandom random;
    private final double samplingProbability;
    private final CreatedAccountIds createdAccountIds;
    private final long firstAccountId;
    private long idOfLatestCreatedAccount;
    private final long nodeId;
    private final ExpectedFCMFamily expectedFCMFamily;
    private static final long UPDATED_BALANCE = 1000000L;
    private static final int SIZE_AFTER_PADDING = 100;

    AccountTransactionFactory(PTTRandom random, double samplingProbability, ExpectedFCMFamily expectedFCMFamily, long nodeId, long totalAccountsToBeCreated, long firstAccountId) {
        this.random = random;
        this.samplingProbability = samplingProbability;
        this.expectedFCMFamily = expectedFCMFamily;
        this.nodeId = nodeId;
        this.idOfLatestCreatedAccount = this.firstAccountId = firstAccountId + nodeId * totalAccountsToBeCreated;
        this.createdAccountIds = new CreatedAccountIds(random);
    }

    public Pair<MapKey, VirtualMerkleTransaction.Builder> buildCreateAccountTransaction() {
        long accountId;
        MapKey key;
        do {
            accountId = this.getNextAccountId();
            key = new MapKey(this.nodeId, this.nodeId, accountId);
        } while (this.expectedFCMFamily.getExpectedMap().containsKey(key));
        CreateAccount createAccount = CreateAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(key.getAccountId()).setSendThreshold(key.getAccountId()).setReceiveThreshold(key.getAccountId()).setRequireSignature(false).setUid(this.random.nextLong()).build();
        VirtualMerkleTransaction.Builder virtualMerkleTransactionBuilder = VirtualMerkleTransaction.newBuilder().setCreateAccount(createAccount).setOriginNode(this.nodeId);
        if (this.random.nextDouble() <= this.samplingProbability) {
            ExpectedValue expectedValue = new ExpectedValue(EntityType.VIRTUAL_MERKLE_ACCOUNT, new LifecycleStatus(TransactionState.INITIALIZED, TransactionType.Create, Instant.now().getEpochSecond(), this.nodeId));
            this.createdAccountIds.addAccountId(accountId);
            this.expectedFCMFamily.addEntityToExpectedMap(key, expectedValue);
            virtualMerkleTransactionBuilder.setSampled(true);
        } else {
            virtualMerkleTransactionBuilder.setSampled(false);
        }
        return Pair.of((Object)key, (Object)virtualMerkleTransactionBuilder);
    }

    public Pair<MapKey, VirtualMerkleTransaction.Builder> buildUpdateAccountTransaction(HotspotConfiguration hotspot) {
        long idOfAccountToBeUpdate = this.getIdOfAccountToBeUpdated(hotspot);
        MapKey key = new MapKey(this.nodeId, this.nodeId, idOfAccountToBeUpdate);
        UpdateAccount updateAccount = UpdateAccount.newBuilder().setShardID(this.nodeId).setRealmID(this.nodeId).setAccountID(idOfAccountToBeUpdate).setBalance(1000000L).setSendThreshold(idOfAccountToBeUpdate).setReceiveThreshold(idOfAccountToBeUpdate).setRequireSignature(false).build();
        VirtualMerkleTransaction.Builder virtualMerkleTransactionBuilder = VirtualMerkleTransaction.newBuilder().setUpdateAccount(updateAccount).setOriginNode(this.nodeId).setSampled(false);
        this.expectedFCMFamily.getExpectedMap().computeIfPresent(key, (mapKey, expectedValue) -> {
            expectedValue.setLatestSubmitStatus(new LifecycleStatus(TransactionState.INITIALIZED, TransactionType.Update, Instant.now().getEpochSecond(), this.nodeId));
            virtualMerkleTransactionBuilder.setSampled(true);
            return expectedValue;
        });
        return Pair.of((Object)key, (Object)virtualMerkleTransactionBuilder);
    }

    public Pair<MapKey, VirtualMerkleTransaction.Builder> buildDeleteAccountTransaction() {
        Long idOfAccountToBeDeleted = this.createdAccountIds.removeRandomId(this.firstAccountId, this.idOfLatestCreatedAccount);
        MapKey key = new MapKey(this.nodeId, this.nodeId, idOfAccountToBeDeleted.longValue());
        DeleteAccount deleteAccount = DeleteAccount.newBuilder().setShardID(this.nodeId).setRealmID(this.nodeId).setAccountID(idOfAccountToBeDeleted).build();
        VirtualMerkleTransaction.Builder virtualMerkleTransactionBuilder = VirtualMerkleTransaction.newBuilder().setDeleteAccount(deleteAccount).setOriginNode(this.nodeId).setSampled(false);
        this.expectedFCMFamily.getExpectedMap().computeIfPresent(key, (mapKey, expectedValue) -> {
            expectedValue.setLatestSubmitStatus(new LifecycleStatus(TransactionState.INITIALIZED, TransactionType.Delete, Instant.now().getEpochSecond(), this.nodeId));
            virtualMerkleTransactionBuilder.setSampled(true);
            return expectedValue;
        });
        return Pair.of((Object)key, (Object)virtualMerkleTransactionBuilder);
    }

    private long getNextAccountId() {
        return this.idOfLatestCreatedAccount++;
    }

    public static int getSizeAfterPadding() {
        return 100;
    }

    private long getIdOfAccountToBeUpdated(HotspotConfiguration hotspot) {
        if (hotspot == null || !hotspot.shouldBeUsed()) {
            return this.createdAccountIds.getRandomId(this.firstAccountId, this.idOfLatestCreatedAccount);
        }
        return this.createdAccountIds.getRandomId(hotspot.getSize());
    }

    private static class CreatedAccountIds {
        private final ArrayList<Long> createdAccountIds = new ArrayList();
        private final PTTRandom random;

        public CreatedAccountIds(PTTRandom random) {
            this.random = random;
        }

        public void addAccountId(long accountId) {
            this.createdAccountIds.add(accountId);
        }

        public Long getRandomId(long lower, long upper) {
            return this.random.nextLong(lower, upper);
        }

        public Long getRandomId(int sizeLimit) {
            if (this.createdAccountIds.isEmpty()) {
                return this.random.nextLong();
            }
            int idx = this.random.nextInt(sizeLimit);
            return this.createdAccountIds.get(idx);
        }

        public Long removeRandomId(long firstAccountId, long idOfLatestCreatedAccount) {
            if (this.createdAccountIds.isEmpty()) {
                return this.random.nextLong(firstAccountId, idOfLatestCreatedAccount);
            }
            if (this.createdAccountIds.size() == 1) {
                return this.createdAccountIds.remove(0);
            }
            int idx = this.random.nextInt(this.createdAccountIds.size());
            if (idx == this.createdAccountIds.size() - 1) {
                return this.createdAccountIds.remove(idx);
            }
            Long chosen = this.createdAccountIds.get(idx);
            Long lastOne = this.createdAccountIds.remove(this.createdAccountIds.size() - 1);
            this.createdAccountIds.set(idx, lastOne);
            return chosen;
        }
    }
}

