/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.SerializableLong;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.utility.ThresholdLimitingHandler;
import com.swirlds.demo.merkle.map.FCMTransactionHandler;
import com.swirlds.demo.merkle.map.FCMTransactionUtils;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.ControlAction;
import com.swirlds.demo.platform.NextSeqConsList;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.PlatformTestingToolMain;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.ProgressCfg;
import com.swirlds.demo.platform.SyntheticBottleneckConfig;
import com.swirlds.demo.platform.TransactionCounter;
import com.swirlds.demo.platform.TransactionCounterList;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.demo.platform.actions.Action;
import com.swirlds.demo.platform.actions.QuorumResult;
import com.swirlds.demo.platform.actions.QuorumTriggeredAction;
import com.swirlds.demo.platform.freeze.FreezeTransactionHandler;
import com.swirlds.demo.platform.fs.stresstest.proto.Activity;
import com.swirlds.demo.platform.fs.stresstest.proto.AppTransactionSignatureType;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.FreezeTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.RandomBytesTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.SimpleAction;
import com.swirlds.demo.platform.fs.stresstest.proto.StateSignatureTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransactionWrapper;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.platform.iss.IssLeaf;
import com.swirlds.demo.platform.nft.NftLedgerStatistics;
import com.swirlds.demo.virtualmerkle.transaction.handler.VirtualMerkleTransactionHandler;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SoftwareVersionPayload;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.SaveExpectedMapHandler;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.VerificationStatus;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;
import org.hiero.consensus.roster.RosterUtils;

public class PlatformTestingToolConsensusStateEventHandler
implements ConsensusStateEventHandler<PlatformTestingToolState> {
    private static final Logger logger = LogManager.getLogger(PlatformTestingToolState.class);
    private static final Marker LOGM_DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker LOGM_EXPIRATION = MarkerManager.getMarker((String)"EXPIRATION");
    private static final Marker LOGM_STARTUP = MarkerManager.getMarker((String)"STARTUP");
    private static final long EXCEPTION_RATE_THRESHOLD = 10L;
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    static final String STAT_TIMER_THREAD_NAME = "stat timer PTTState";
    private static final long minTransTimestampIncrNanos = 1000L;
    private static final String HANDLE_TRANSACTION_CATEGORY = "HandleTransaction";
    private static long htCountFCM;
    private static long htFCMSumNano;
    private static final RunningAverageMetric.Config HT_FCM_MICRO_SEC_CONFIG;
    private static RunningAverageMetric htFCMMicroSec;
    private static long htCountFCQ;
    private static long htFCQSumNano;
    private static final RunningAverageMetric.Config HT_FCQ_MICRO_SEC_CONFIG;
    private static RunningAverageMetric htFCQMicroSec;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static long htCountExpiration;
    private static long htFCQExpirationSumMicro;
    private static final RunningAverageMetric.Config HT_FCQ_EXPIRATION_MICRO_SEC_CONFIG;
    private static RunningAverageMetric htFCQExpirationMicroSec;
    private static final RunningAverageMetric.Config HT_FCM_SIZE_CONFIG;
    private static RunningAverageMetric htFCMSize;
    private static long htFCMAccounts;
    private static final RunningAverageMetric.Config HT_FCQ_SIZE_CONFIG;
    private static RunningAverageMetric htFCQSize;
    private static long htFCQAccounts;
    private static final RunningAverageMetric.Config HT_FCQ_RECORDS_CONFIG;
    private static RunningAverageMetric htFCQRecords;
    private static long htFCQRecordsCount;
    private final PlatformStateFacade platformStateFacade;
    private Platform platform;
    private ThresholdLimitingHandler<Throwable> exceptionRateLimiter;
    private ProgressCfg progressCfg;
    protected long roundCounter = 0L;
    private long lastPurgeTimestamp = 0L;
    private Instant previousTimestamp;
    private QuorumTriggeredAction<ControlAction> controlQuorum;
    private final AtomicLong freezeRound = new AtomicLong(-1L);
    static AtomicLong totalTransactionSignatureCount;
    static AtomicLong expectedInvalidSignatureCount;

    public PlatformTestingToolConsensusStateEventHandler(@NonNull PlatformStateFacade platformStateFacade) {
        this.platformStateFacade = platformStateFacade;
    }

    public static void initStatistics(Platform platform) {
        if (htFCMMicroSec != null) {
            return;
        }
        htFCQMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)HT_FCQ_MICRO_SEC_CONFIG);
        htFCQExpirationMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)HT_FCQ_EXPIRATION_MICRO_SEC_CONFIG);
        htFCMSize = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)HT_FCM_SIZE_CONFIG);
        htFCQSize = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)HT_FCQ_SIZE_CONFIG);
        htFCQRecords = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)HT_FCQ_RECORDS_CONFIG);
        NftLedgerStatistics.register(platform);
        int SAMPLING_PERIOD = 5000;
        Timer statTimer = new Timer(STAT_TIMER_THREAD_NAME, true);
        statTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PlatformTestingToolConsensusStateEventHandler.getCurrentTransactionStat();
            }
        }, 0L, 5000L);
    }

    private static void getCurrentTransactionStat() {
        if (htFCMMicroSec == null) {
            return;
        }
        if (htCountFCM > 0L) {
            htFCMMicroSec.update((double)htFCMSumNano / (double)htCountFCM * 0.001);
        } else {
            htFCMMicroSec.update(0.0);
        }
        htFCMSumNano = 0L;
        htCountFCM = 0L;
        if (htCountFCQ > 0L) {
            htFCQMicroSec.update((double)htFCQSumNano / (double)htCountFCQ * 0.001);
        } else {
            htFCQMicroSec.update(0.0);
        }
        htFCQSumNano = 0L;
        htCountFCQ = 0L;
        if (htCountExpiration > 0L) {
            htFCQExpirationMicroSec.update((double)htFCQExpirationSumMicro / (double)htCountExpiration);
        } else {
            htFCQExpirationMicroSec.update(0.0);
        }
        htFCQExpirationSumMicro = 0L;
        htCountExpiration = 0L;
        htFCMSize.update((double)htFCMAccounts);
        htFCQSize.update((double)htFCQAccounts);
        htFCQRecords.update((double)htFCQRecordsCount);
    }

    QuorumTriggeredAction<ControlAction> getControlQuorum() {
        return this.controlQuorum;
    }

    void initControlStructures(Action<Long, ControlAction> action) {
        int nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)this.platform.getSelfId().id());
        this.controlQuorum = new QuorumTriggeredAction<ControlAction>(() -> nodeIndex, () -> this.platform.getRoster().rosterEntries().size(), () -> RosterUtils.getNumberWithWeight((Roster)this.platform.getRoster()), action);
        this.exceptionRateLimiter = new ThresholdLimitingHandler(10L);
    }

    private void validateTimestamp(Instant timestamp) {
        Instant previousTransTimestampPlusIncr;
        if (this.previousTimestamp != null && timestamp.isBefore(previousTransTimestampPlusIncr = this.previousTimestamp.plusNanos(1000L))) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Transaction has timestamp {} which is earlier than previous timestamp {} plus {} nanos: {}", (Object)timestamp, (Object)this.previousTimestamp, (Object)1000L, (Object)previousTransTimestampPlusIncr);
        }
        this.previousTimestamp = timestamp;
    }

    private boolean checkIfSignatureIsInvalid(Transaction trans, @NonNull PlatformTestingToolState state) {
        if (state.getConfig().isAppendSig()) {
            return PlatformTestingToolConsensusStateEventHandler.validateSignatures(trans);
        }
        return false;
    }

    private void delay(@NonNull PlatformTestingToolState state) {
        if (state.getConfig().getDelayCfg() != null) {
            int delay = state.getConfig().getDelayCfg().getRandomDelay();
            try {
                logger.info(LOGM_DEMO_INFO, "Will sleep for {}ms on normal delay", (Object)delay);
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                logger.info(LOGM_DEMO_INFO, "", (Throwable)e);
            }
        }
        SyntheticBottleneckConfig.getActiveConfig().throttleIfNeeded(this.platform.getSelfId().id());
    }

    private Optional<TestTransaction> unpackTransaction(Transaction trans, @NonNull PlatformTestingToolState state) {
        try {
            byte[] payloadBytes = trans.getApplicationTransaction().toByteArray();
            if (state.getConfig().isAppendSig()) {
                byte[] testTransactionRawBytes = TestTransactionWrapper.parseFrom(payloadBytes).getTestTransactionRawBytes().toByteArray();
                return Optional.of(TestTransaction.parseFrom(testTransactionRawBytes));
            }
            return Optional.of(TestTransaction.parseFrom(payloadBytes));
        }
        catch (InvalidProtocolBufferException ex) {
            this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "InvalidProtocolBufferException", error));
            return Optional.empty();
        }
    }

    private void purgeExpiredRecordsIfNeeded(TestTransaction testTransaction, Instant timestamp, @NonNull PlatformTestingToolState state) {
        if (!(testTransaction.hasControlTransaction() && testTransaction.getControlTransaction().getType() == ControlType.EXIT_VALIDATION || state.getFcmFamily().getAccountFCQMap().isEmpty())) {
            try {
                this.purgeExpiredRecords(state, timestamp.getEpochSecond());
            }
            catch (Throwable ex) {
                this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to purge expired records", error));
            }
        }
    }

    private void logIfFirstTransaction(NodeId id, @NonNull PlatformTestingToolState state) {
        int nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)id.id());
        if (this.progressCfg != null && this.progressCfg.getProgressMarker() > 0 && ((TransactionCounter)state.getTransactionCounter().get(nodeIndex)).getAllTransactionAmount() == 0L) {
            logger.info(LOGM_DEMO_INFO, "PlatformTestingDemo HANDLE ALL START");
        }
    }

    private void handleBytesTransaction(@NonNull TestTransaction testTransaction, @NonNull NodeId id, @NonNull PlatformTestingToolState state) {
        Objects.requireNonNull(testTransaction, "testTransaction must not be null");
        Objects.requireNonNull(id, "id must not be null");
        int nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)id.id());
        RandomBytesTransaction bytesTransaction = testTransaction.getBytesTransaction();
        if (bytesTransaction.getIsInserSeq()) {
            long seq = Utilities.toLong((byte[])bytesTransaction.getData().toByteArray());
            if (((SerializableLong)state.getNextSeqCons().get(nodeIndex)).getValue() != seq) {
                logger.error(LogMarker.EXCEPTION.getMarker(), String.valueOf(this.platform.getSelfId()) + " error, new (id=" + String.valueOf(id) + ") seq should be " + String.valueOf(state.getNextSeqCons().get(nodeIndex)) + " but is " + seq);
            }
            ((SerializableLong)state.getNextSeqCons().get(nodeIndex)).getAndIncrement();
        }
    }

    private void handleVirtualMerkleTransaction(@NonNull VirtualMerkleTransaction virtualMerkleTransaction, @NonNull NodeId id, @NonNull Instant consensusTimestamp, @NonNull PlatformTestingToolState state) {
        Objects.requireNonNull(virtualMerkleTransaction, "virtualMerkleTransaction must not be null");
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(consensusTimestamp, "consensusTimestamp must not be null");
        int nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)id.id());
        VirtualMerkleTransactionHandler.handle(consensusTimestamp, virtualMerkleTransaction, state.getStateExpectedMap(), state.getVirtualMap(), state.getVirtualMapForSmartContracts(), state.getVirtualMapForSmartContractsByteCode());
        if (virtualMerkleTransaction.hasCreateAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).vmCreateAmount;
        } else if (virtualMerkleTransaction.hasUpdateAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).vmUpdateAmount;
        } else if (virtualMerkleTransaction.hasDeleteAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).vmDeleteAmount;
        } else if (virtualMerkleTransaction.hasSmartContract()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).vmContractCreateAmount;
        } else if (virtualMerkleTransaction.hasMethodExecution()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).vmContractExecutionAmount;
        }
    }

    private void handleFCMTransaction(@NonNull TestTransaction testTransaction, @NonNull NodeId id, @NonNull Instant timestamp, boolean invalidSig, @NonNull PlatformTestingToolState state) {
        Objects.requireNonNull(testTransaction, "testTransaction must not be null");
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        int nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)id.id());
        FCMTransaction fcmTransaction = testTransaction.getFcmTransaction();
        ExpectedFCMFamily expectedFCMFamily = state.getStateExpectedMap();
        if (fcmTransaction.hasActivity()) {
            Activity.ActivityType activityType = fcmTransaction.getActivity().getType();
            if (nodeIndex == 0 && activityType == Activity.ActivityType.SAVE_EXPECTED_MAP) {
                TransactionSubmitter.setForcePauseCanSubmitMore(new AtomicBoolean(true));
                SaveExpectedMapHandler.serialize(expectedFCMFamily.getExpectedMap(), (File)new File("data/lifecycle"), (String)SaveExpectedMapHandler.createExpectedMapName((long)this.platform.getSelfId().id(), (Instant)timestamp), (boolean)false);
                TransactionSubmitter.setForcePauseCanSubmitMore(new AtomicBoolean(false));
                logger.info(LOGM_DEMO_INFO, "handling SAVE_EXPECTED_MAP");
            } else if (activityType == Activity.ActivityType.SAVE_EXPECTED_MAP) {
                logger.info(LOGM_DEMO_INFO, "Received SAVE_EXPECTED_MAP transaction from node {}", (Object)id);
            } else {
                logger.info(LogMarker.EXCEPTION.getMarker(), "unknown Activity type");
            }
            return;
        }
        if (fcmTransaction.hasDummyTransaction()) {
            return;
        }
        List<MapKey> keys = FCMTransactionUtils.getMapKeys(fcmTransaction);
        TransactionType transactionType = FCMTransactionUtils.getTransactionType(fcmTransaction);
        EntityType entityType = FCMTransactionUtils.getEntityType(fcmTransaction);
        long epochMillis = timestamp.toEpochMilli();
        long originId = fcmTransaction.getOriginNode();
        if (keys.isEmpty() && entityType != EntityType.NFT || transactionType == null || entityType == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid Transaction: keys: {}, transactionType: {}, entityType: {}", keys, (Object)transactionType, (Object)entityType);
            return;
        }
        if (!expectedFCMFamily.shouldHandleForKeys(keys, transactionType, state.getConfig(), entityType, epochMillis, originId) && entityType != EntityType.NFT) {
            logger.info(LogMarker.DEMO_INFO.getMarker(), "A transaction ignored by expected map: {}.", (Object)this.roundCounter);
            return;
        }
        if (state.getConfig().isAppendSig() && invalidSig != fcmTransaction.getInvalidSig()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unexpected signature verification result: actual: {}; expected:{}", new Supplier[]{() -> invalidSig ? "INVALID" : "VALID", () -> fcmTransaction.getInvalidSig() ? "INVALID" : "VALID"});
            expectedFCMFamily.setLatestHandledStatusForKey(keys.getFirst(), entityType, null, TransactionState.INVALID_SIG, transactionType, epochMillis, originId, true);
            return;
        }
        if (invalidSig) {
            expectedFCMFamily.setLatestHandledStatusForKey(keys.getFirst(), entityType, null, TransactionState.EXPECTED_INVALID_SIG, transactionType, epochMillis, originId, false);
        }
        try {
            FCMTransactionHandler.performOperation(fcmTransaction, state, expectedFCMFamily, originId, epochMillis, entityType, timestamp.getEpochSecond() + (long)state.getConfig().getFcqTtl(), state.getExpirationQueue(), state.getAccountsWithExpiringRecords());
        }
        catch (Exception ex) {
            this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "Exceptions while handling transaction: {} {} for {}, originId:{}", (Object)transactionType, (Object)entityType, (Object)keys, (Object)originId, error));
            for (MapKey key : keys) {
                expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, null, TransactionState.HANDLE_FAILED, transactionType, timestamp.toEpochMilli(), originId, true);
            }
        }
        if (fcmTransaction.hasCreateAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmCreateAmount;
            if (this.progressCfg != null) {
                this.logProgress(id, this.progressCfg.getProgressMarker(), PAYLOAD_TYPE.TYPE_FCM_CREATE, this.progressCfg.getExpectedFCMCreateAmount(), ((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmCreateAmount);
            }
        } else if (fcmTransaction.hasTransferBalance()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmTransferAmount;
            if (this.progressCfg != null) {
                this.logProgress(id, this.progressCfg.getProgressMarker(), PAYLOAD_TYPE.TYPE_FCM_TRANSFER, this.progressCfg.getExpectedFCMTransferAmount(), ((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmTransferAmount);
            }
        } else if (fcmTransaction.hasDeleteAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmDeleteAmount;
            if (this.progressCfg != null) {
                this.logProgress(id, this.progressCfg.getProgressMarker(), PAYLOAD_TYPE.TYPE_FCM_DELETE, this.progressCfg.getExpectedFCMDeleteAmount(), ((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmDeleteAmount);
            }
        } else if (fcmTransaction.hasUpdateAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmUpdateAmount;
            if (this.progressCfg != null) {
                this.logProgress(id, this.progressCfg.getProgressMarker(), PAYLOAD_TYPE.TYPE_FCM_UPDATE, this.progressCfg.getExpectedFCMUpdateAmount(), ((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmUpdateAmount);
            }
        } else if (fcmTransaction.hasAssortedAccount()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmAssortedAmount;
            if (this.progressCfg != null) {
                this.logProgress(id, this.progressCfg.getProgressMarker(), PAYLOAD_TYPE.TYPE_FCM_ASSORTED, this.progressCfg.getExpectedFCMAssortedAmount(), ((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmAssortedAmount);
            }
        } else if (fcmTransaction.hasAssortedFCQ()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmFCQAssortedAmount;
        } else if (fcmTransaction.hasCreateAccountFCQ()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmFCQCreateAmount;
        } else if (fcmTransaction.hasUpdateAccountFCQ()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmFCQUpdateAmount;
        } else if (fcmTransaction.hasTransferBalanceFCQ()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmFCQTransferAmount;
        } else if (fcmTransaction.hasDeleteFCQNode()) {
            ++((TransactionCounter)state.getTransactionCounter().get((int)nodeIndex)).fcmFCQDeleteAmount;
        }
    }

    private void handleControlTransaction(@NonNull TestTransaction testTransaction, @NonNull NodeId id, @NonNull Instant timestamp, @NonNull PlatformTestingToolState state) {
        Objects.requireNonNull(testTransaction, "testTransaction must not be null");
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        long nodeIndex = RosterUtils.getIndex((Roster)this.platform.getRoster(), (long)id.id());
        ControlTransaction msg = testTransaction.getControlTransaction();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> id;
        supplierArray[1] = msg::getType;
        supplierArray[2] = () -> timestamp;
        logger.info(LogMarker.DEMO_INFO.getMarker(), "Handling Control Transaction [ originatingNodeId = {}, type = {}, consensusTimestamp = {} ]", supplierArray);
        this.controlQuorum.withAutoReset().check(Long.valueOf(nodeIndex), new ControlAction(timestamp, msg.getType()));
        state.setQuorumResult((QuorumResult<ControlAction>)this.controlQuorum.getQuorumResult().copy());
    }

    private void handleFreezeTransaction(TestTransaction testTransaction, State state) {
        FreezeTransaction freezeTx = testTransaction.getFreezeTransaction();
        FreezeTransactionHandler.freeze(freezeTx, this.platformStateFacade, state);
    }

    private void handleSimpleAction(SimpleAction simpleAction, PlatformTestingToolState state) {
        if (simpleAction == SimpleAction.CAUSE_ISS) {
            state.getIssLeaf().setWriteRandom(true);
        }
    }

    private void preHandleTransaction(Transaction transaction, Event event, PlatformTestingToolState state, Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            byte[] payloadBytes = transaction.getApplicationTransaction().toByteArray();
            TestTransactionWrapper testTransactionWrapper = TestTransactionWrapper.parseFrom(payloadBytes);
            byte[] testTransactionRawBytes = testTransactionWrapper.getTestTransactionRawBytes().toByteArray();
            TestTransaction testTransaction = TestTransaction.parseFrom(testTransactionRawBytes);
            if (testTransaction.getBodyCase() == TestTransaction.BodyCase.STATESIGNATURETRANSACTION) {
                this.consumeSystemTransaction(testTransaction, event.getCreatorId(), event.getBirthRound(), stateSignatureTransactionCallback);
            } else {
                this.expandSignatures(transaction, testTransactionWrapper, state);
            }
        }
        catch (InvalidProtocolBufferException ex) {
            this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "InvalidProtocolBufferException", error));
        }
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull PlatformTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        if (!this.initialized.get()) {
            throw new IllegalStateException("onHandleConsensusRound() called before init()");
        }
        this.delay(state);
        this.updateTransactionCounters(state);
        round.forEachEventTransaction((event, transaction) -> this.handleConsensusTransaction((ConsensusEvent)event, (ConsensusTransaction)transaction, state, stateSignatureTransactionCallback));
        if (this.platformStateFacade.isFreezeRound((State)state, round)) {
            this.freezeRound.set(round.getRoundNum());
        }
    }

    private void updateTransactionCounters(PlatformTestingToolState state) {
        if (state.getTransactionCounter() == null || state.getTransactionCounter().size() != this.platform.getRoster().rosterEntries().size()) {
            state.setNextSeqCons(new NextSeqConsList(this.platform.getRoster().rosterEntries().size()));
            logger.info(LogMarker.DEMO_INFO.getMarker(), "resetting transaction counters");
            state.setTransactionCounter(new TransactionCounterList(this.platform.getRoster().rosterEntries().size()));
            for (int id = 0; id < this.platform.getRoster().rosterEntries().size(); ++id) {
                state.getTransactionCounter().add(new TransactionCounter(id));
            }
        }
    }

    private void handleConsensusTransaction(ConsensusEvent event, ConsensusTransaction trans, PlatformTestingToolState state, Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        this.handleTransaction(event.getCreatorId(), event.getBirthRound(), event.getTimeCreated(), trans.getConsensusTimestamp(), trans, state, stateSignatureTransactionCallback);
    }

    private void handleTransaction(@NonNull NodeId id, long eventBirthRound, @NonNull Instant timeCreated, @NonNull Instant timestamp, @NonNull ConsensusTransaction trans, @NonNull PlatformTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        FCMTransaction fcmTransaction;
        if (state.getConfig().isAppendSig()) {
            try {
                FCMTransaction fcmTransaction2;
                TestTransactionWrapper testTransactionWrapper = TestTransactionWrapper.parseFrom(trans.getApplicationTransaction().toByteArray());
                byte[] testTransactionRawBytes = testTransactionWrapper.getTestTransactionRawBytes().toByteArray();
                byte[] publicKey = testTransactionWrapper.getPublicKeyRawBytes().toByteArray();
                byte[] signature = testTransactionWrapper.getSignaturesRawBytes().toByteArray();
                boolean expectingInvalidSignature = false;
                TestTransaction testTransaction = TestTransaction.parseFrom(testTransactionRawBytes);
                if (testTransaction.getBodyCase() == TestTransaction.BodyCase.STATESIGNATURETRANSACTION) {
                    this.consumeSystemTransaction(testTransaction, id, eventBirthRound, stateSignatureTransactionCallback);
                    return;
                }
                if (testTransaction.getBodyCase() == TestTransaction.BodyCase.FCMTRANSACTION && (fcmTransaction2 = testTransaction.getFcmTransaction()).getInvalidSig()) {
                    expectingInvalidSignature = true;
                }
                totalTransactionSignatureCount.incrementAndGet();
                TransactionSignature s = (TransactionSignature)trans.getMetadata();
                if (s != null && s.getSignatureStatus() != VerificationStatus.VALID && !expectingInvalidSignature) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid Transaction Signature [status = {}, signatureType = {}, publicKey = {}, signature = {}, data = {}, actualPublicKey = {}, actualSignature = {}, actualData = {} ]", (Object)s.getSignatureStatus(), (Object)s.getSignatureType(), (Object)CommonUtils.hex((byte[])publicKey), (Object)CommonUtils.hex((byte[])signature), (Object)CommonUtils.hex((byte[])testTransactionRawBytes), (Object)CommonUtils.hex((Bytes)s.getPublicKey()), (Object)CommonUtils.hex((Bytes)s.getSignature()), (Object)CommonUtils.hex((Bytes)s.getMessage()));
                } else if (s != null && s.getSignatureStatus() != VerificationStatus.VALID && expectingInvalidSignature) {
                    expectedInvalidSignatureCount.incrementAndGet();
                }
            }
            catch (InvalidProtocolBufferException ex) {
                this.exceptionRateLimiter.handle((Object)ex, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "InvalidProtocolBufferException while checking signature", error));
            }
        }
        long startTime = System.nanoTime();
        this.validateTimestamp(timestamp);
        Optional<TestTransaction> testTransaction = this.unpackTransaction((Transaction)trans, state);
        if (testTransaction.isEmpty()) {
            return;
        }
        long splitTime1 = System.nanoTime();
        this.purgeExpiredRecordsIfNeeded(testTransaction.get(), timestamp, state);
        long splitTime2 = System.nanoTime();
        this.logIfFirstTransaction(id, state);
        switch (testTransaction.get().getBodyCase()) {
            case BYTESTRANSACTION: {
                this.handleBytesTransaction(testTransaction.get(), id, state);
                break;
            }
            case FCMTRANSACTION: {
                this.handleFCMTransaction(testTransaction.get(), id, timestamp, this.checkIfSignatureIsInvalid((Transaction)trans, state), state);
                break;
            }
            case CONTROLTRANSACTION: {
                this.handleControlTransaction(testTransaction.get(), id, timestamp, state);
                break;
            }
            case FREEZETRANSACTION: {
                this.handleFreezeTransaction(testTransaction.get(), (State)state);
                break;
            }
            case SIMPLEACTION: {
                this.handleSimpleAction(testTransaction.get().getSimpleAction(), state);
                break;
            }
            case VIRTUALMERKLETRANSACTION: {
                this.handleVirtualMerkleTransaction(testTransaction.get().getVirtualMerkleTransaction(), id, timeCreated, state);
                break;
            }
            case STATESIGNATURETRANSACTION: {
                this.consumeSystemTransaction(testTransaction.get(), id, eventBirthRound, stateSignatureTransactionCallback);
                return;
            }
            default: {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Unrecognized transaction!");
            }
        }
        long htNetTime = System.nanoTime() - splitTime2 + (splitTime1 - startTime);
        if (testTransaction.get().hasFcmTransaction() && !(fcmTransaction = testTransaction.get().getFcmTransaction()).hasActivity() && !fcmTransaction.hasDummyTransaction()) {
            switch (Objects.requireNonNull(FCMTransactionUtils.getEntityType(fcmTransaction))) {
                case Crypto: {
                    htFCMSumNano += htNetTime;
                    ++htCountFCM;
                    htFCMAccounts = state.getFcmFamily().getMap().size();
                    break;
                }
                case FCQ: {
                    htFCQSumNano += htNetTime;
                    ++htCountFCQ;
                    htFCQAccounts = state.getFcmFamily().getAccountFCQMap().size();
                }
            }
        }
    }

    private void consumeSystemTransaction(@NonNull TestTransaction transaction, @NonNull NodeId creator, long eventBirthRound, @NonNull Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        com.hedera.hapi.platform.event.StateSignatureTransaction stateSignatureTransaction = this.convertStateSignatureTransactionFromTestToSourceType(transaction.getStateSignatureTransaction());
        stateSignatureTransactionCallback.accept((ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>)new ScopedSystemTransaction(creator, eventBirthRound, (Object)stateSignatureTransaction));
    }

    private com.hedera.hapi.platform.event.StateSignatureTransaction convertStateSignatureTransactionFromTestToSourceType(StateSignatureTransaction stateSignatureTransaction) {
        return com.hedera.hapi.platform.event.StateSignatureTransaction.newBuilder().round(stateSignatureTransaction.getRound()).signature(Bytes.wrap((byte[])stateSignatureTransaction.getSignature().toByteArray())).hash(Bytes.wrap((byte[])stateSignatureTransaction.getHash().toByteArray())).build();
    }

    private void genesisInit(PlatformTestingToolState state) {
        logger.info(LOGM_STARTUP, "Set QuorumResult from genesisInit()");
        state.setQuorumResult(new QuorumResult<ControlAction>(this.platform.getRoster().rosterEntries().size()));
        state.setIssLeaf(new IssLeaf());
    }

    private MessageDigest createKeccakDigest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("KECCAK-256");
        }
        catch (NoSuchAlgorithmException ignored) {
            try {
                digest = MessageDigest.getInstance("SHA3-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return digest;
    }

    private Bytes keccak256(Bytes bytes) {
        MessageDigest keccakDigest = this.createKeccakDigest();
        bytes.writeTo(keccakDigest);
        return Bytes.wrap((byte[])keccakDigest.digest());
    }

    public static Bytes fromByteString(ByteString byteString) {
        return Bytes.wrap((byte[])byteString.toByteArray());
    }

    private void expandSignatures(Transaction trans, TestTransactionWrapper testTransactionWrapper, PlatformTestingToolState state) {
        if (state.getConfig().isAppendSig()) {
            SignatureType signatureType;
            Bytes testTransactionRawBytes = PlatformTestingToolConsensusStateEventHandler.fromByteString(testTransactionWrapper.getTestTransactionRawBytes());
            Bytes publicKey = PlatformTestingToolConsensusStateEventHandler.fromByteString(testTransactionWrapper.getPublicKeyRawBytes());
            Bytes signature = PlatformTestingToolConsensusStateEventHandler.fromByteString(testTransactionWrapper.getSignaturesRawBytes());
            AppTransactionSignatureType AppSignatureType = testTransactionWrapper.getSignatureType();
            Bytes signaturePayload = testTransactionRawBytes;
            if (AppSignatureType == AppTransactionSignatureType.ED25519) {
                signatureType = SignatureType.ED25519;
            } else if (AppSignatureType == AppTransactionSignatureType.ECDSA_SECP256K1) {
                signatureType = SignatureType.ECDSA_SECP256K1;
                signaturePayload = this.keccak256(testTransactionRawBytes);
            } else if (AppSignatureType == AppTransactionSignatureType.RSA) {
                signatureType = SignatureType.RSA;
            } else {
                throw new UnsupportedOperationException("Unknown application signature type " + String.valueOf((Object)AppSignatureType));
            }
            TransactionSignature transactionSignature = new TransactionSignature(signaturePayload, publicKey, signature, signatureType);
            trans.setMetadata((Object)transactionSignature);
            CRYPTOGRAPHY.verifySync(transactionSignature);
        }
    }

    private void logProgress(@NonNull NodeId id, int markerPercentage, @NonNull PAYLOAD_TYPE type, long expectedAmount, long currentAmount) {
        if (markerPercentage != 0 && currentAmount != 0L && expectedAmount != 0L) {
            if (currentAmount == 1L) {
                logger.info(LOGM_DEMO_INFO, "PlatformTestingDemo id {} HANDLE {} START", (Object)id, (Object)type);
            } else if (currentAmount == expectedAmount) {
                logger.info(LOGM_DEMO_INFO, "PlatformTestingDemo id {} HANDLE {} END", (Object)id, (Object)type);
            } else {
                int reportTimes = (int)Math.ceil(100.0 / (double)markerPercentage);
                for (int i = 1; i <= reportTimes; ++i) {
                    int percentage = Math.min(100, i * markerPercentage);
                    long reportNumber = expectedAmount * (long)percentage / 100L;
                    if (currentAmount != reportNumber) continue;
                    logger.info(LOGM_DEMO_INFO, "PlatformTestingDemo id {} HANDLE {} {}% currentAmount {} ", (Object)id, (Object)type, (Object)percentage, (Object)currentAmount);
                }
            }
        }
    }

    private static boolean validateSignatures(Transaction trans) {
        boolean invalidSig = false;
        TransactionSignature signature = (TransactionSignature)trans.getMetadata();
        if (signature != null && VerificationStatus.INVALID.equals((Object)signature.getSignatureStatus())) {
            invalidSig = true;
        }
        return invalidSig;
    }

    public long purgeExpiredRecords(PlatformTestingToolState state, long consensusCurrentTimestamp) {
        this.lastPurgeTimestamp = consensusCurrentTimestamp;
        long startTime = System.nanoTime();
        long removedNum = this.removeExpiredRecordsInExpirationQueue(state, consensusCurrentTimestamp);
        if (removedNum > 0L) {
            long timeTakenMicro = (System.nanoTime() - startTime) / 1000L;
            logger.info(LOGM_EXPIRATION, "Finish removing expired records from FCQs. Has removed: {} in {} ms", (Object)removedNum, (Object)timeTakenMicro);
            htCountExpiration += removedNum;
            htFCQExpirationSumMicro += timeTakenMicro;
        }
        return removedNum;
    }

    private long removeExpiredRecordsInExpirationQueue(PlatformTestingToolState state, long consensusCurrentTimestamp) {
        long removedNumOfRecords = state.removeExpiredRecordsInExpirationQueue(consensusCurrentTimestamp);
        htFCQRecordsCount = state.getExpirationQueue().size();
        return removedNumOfRecords;
    }

    public void onPreHandle(@NonNull Event event, @NonNull PlatformTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<com.hedera.hapi.platform.event.StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(v -> this.preHandleTransaction((Transaction)v, event, state, stateSignatureTransactionCallback));
    }

    public void onStateInitialized(@NonNull PlatformTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        if (trigger == InitTrigger.RESTART) {
            state.rebuildExpectedMapFromState(Instant.EPOCH, true);
            state.rebuildExpirationQueue();
        }
        this.platform = platform;
        state.setSelfId(platform.getSelfId());
        UnsafeMutablePTTStateAccessor.getInstance().setMutableState(platform.getSelfId(), state);
        this.initialized.set(true);
        TransactionSubmitter.setForcePauseCanSubmitMore(new AtomicBoolean(false));
        String[] parameters = ParameterProvider.getInstance().getParameters();
        if (parameters != null && parameters.length > 0) {
            String jsonFileName = parameters[0];
            PayloadCfgSimple payloadCfgSimple = PlatformTestingToolMain.getPayloadCfgSimple(jsonFileName);
            state.setConfig(payloadCfgSimple);
        } else {
            state.setConfig(new PayloadCfgSimple());
        }
        state.getStateExpectedMap().setNodeId(platform.getSelfId().id());
        state.getStateExpectedMap().setWeightedNodeNum(RosterUtils.getNumberWithWeight((Roster)platform.getRoster()));
        state.initializeExpirationQueueAndAccountsSet();
        logger.info(LOGM_STARTUP, () -> new SoftwareVersionPayload("Trigger and PreviousSoftwareVersion state received in init function", trigger.toString(), Objects.toString(previousVersion)).toString());
        if (trigger == InitTrigger.GENESIS) {
            this.genesisInit(state);
        }
        state.invalidateHash();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        try {
            platform.getContext().getMerkleCryptography().digestTreeAsync((MerkleNode)state).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred during hashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while hashing state. Expect buggy behavior.");
            Thread.currentThread().interrupt();
        }
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull PlatformTestingToolState state) {
        if (round.getRoundNum() == this.freezeRound.get()) {
            return true;
        }
        return round.getRoundNum() % 3L == 0L;
    }

    public void onUpdateWeight(@NonNull PlatformTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull PlatformTestingToolState recoveredState) {
    }

    static {
        HT_FCM_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCMTimeMicroSec").withDescription("average handleTransaction (FCM) Time, microseconds");
        HT_FCQ_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCQTimeMicroSec").withDescription("average handleTransaction (FCQ) Time, microseconds");
        HT_FCQ_EXPIRATION_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCQExpirationMicroSec").withDescription("FCQ Expiration Time per call, microseconds");
        HT_FCM_SIZE_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCMSize").withDescription("FCM Tree Size (accounts)").withFormat("%,11.0f");
        HT_FCQ_SIZE_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCQSize").withDescription("FCQ Tree Size (accounts)").withFormat("%,11.0f");
        HT_FCQ_RECORDS_CONFIG = new RunningAverageMetric.Config(HANDLE_TRANSACTION_CATEGORY, "htFCQRecords").withDescription("FCQ Transaction Records").withFormat("%,11.0f");
        totalTransactionSignatureCount = new AtomicLong(0L);
        expectedInvalidSignatureCount = new AtomicLong(0L);
    }
}

