/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.Randotron;
import com.swirlds.common.test.fixtures.WeightGenerator;
import com.swirlds.common.test.fixtures.WeightGenerators;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterBuilder;
import com.swirlds.platform.test.fixtures.event.emitter.StandardEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSourceFactory;
import java.util.Random;

public class EventEmitterBuilder {
    private long randomSeed = 0L;
    private int numNodes = 4;
    private WeightGenerator weightGenerator = WeightGenerators.GAUSSIAN;
    private PlatformContext platformContext = null;

    private EventEmitterBuilder() {
    }

    public static EventEmitterBuilder newBuilder() {
        return new EventEmitterBuilder();
    }

    public EventEmitterBuilder setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public EventEmitterBuilder setNumNodes(int numNodes) {
        this.numNodes = numNodes;
        return this;
    }

    public EventEmitterBuilder setWeightGenerator(WeightGenerator weightGenerator) {
        this.weightGenerator = weightGenerator;
        return this;
    }

    public EventEmitterBuilder setPlatformContext(PlatformContext platformContext) {
        this.platformContext = platformContext;
        return this;
    }

    public StandardEventEmitter build() {
        Randotron random = Randotron.create((long)this.randomSeed);
        if (this.platformContext == null) {
            this.platformContext = TestPlatformContextBuilder.create().build();
        }
        Roster roster = RandomRosterBuilder.create((Random)random).withWeightGenerator(this.weightGenerator).withSize(this.numNodes).build();
        EventSourceFactory eventSourceFactory = new EventSourceFactory(this.numNodes);
        StandardGraphGenerator generator = new StandardGraphGenerator(this.platformContext, this.randomSeed, eventSourceFactory.generateSources(), roster);
        return new StandardEventEmitter(generator);
    }
}

