/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInfo;
import org.mockito.internal.matchers.Equality;
import org.mockito.internal.matchers.text.ValuePrinter;

public class Equals
implements ArgumentMatcher<Object>,
ContainsExtraTypeInfo,
Serializable {
    private final Object wanted;

    public Equals(Object wanted) {
        this.wanted = wanted;
    }

    @Override
    public boolean matches(Object actual) {
        return Equality.areEqual(this.wanted, actual);
    }

    @Override
    public Class<?> type() {
        return this.wanted != null ? this.wanted.getClass() : ArgumentMatcher.super.type();
    }

    public String toString() {
        return this.describe(this.wanted);
    }

    private String describe(Object object) {
        return ValuePrinter.print(object);
    }

    @Override
    public final Object getWanted() {
        return this.wanted;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Equals)) {
            return false;
        }
        Equals other = (Equals)o;
        return this.wanted == null && other.wanted == null || this.wanted != null && this.wanted.equals(other.wanted);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toStringWithType(String className) {
        return "(" + className + ") " + this.describe(this.wanted);
    }

    @Override
    public boolean typeMatches(Object target) {
        return this.wanted != null && target != null && target.getClass() == this.wanted.getClass();
    }
}

