/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.ScopedMock;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.plugins.AnnotationEngine;
import org.mockito.plugins.MemberAccessor;

public class IndependentAnnotationEngine
implements AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public IndependentAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    private Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A annotation, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    @Override
    public AutoCloseable process(Class<?> clazz, Object testInstance) {
        Field[] fields;
        ArrayList<ScopedMock> scopedMocks = new ArrayList<ScopedMock>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean alreadyAssigned = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object mock = this.createMockFor(annotation, field);
                if (mock instanceof ScopedMock) {
                    scopedMocks.add((ScopedMock)mock);
                }
                if (mock == null) continue;
                this.throwIfAlreadyAssigned(field, alreadyAssigned);
                alreadyAssigned = true;
                MemberAccessor accessor = Plugins.getMemberAccessor();
                try {
                    accessor.set(field, testInstance, mock);
                }
                catch (Exception e) {
                    for (ScopedMock scopedMock : scopedMocks) {
                        scopedMock.close();
                    }
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + String.valueOf(annotation), e);
                }
            }
        }
        return () -> {
            for (ScopedMock scopedMock : scopedMocks) {
                scopedMock.closeOnDemand();
            }
        };
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            throw Reporter.moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

