/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.base.utility.Pair;
import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.MerkleLong;
import com.swirlds.demo.merkle.map.FCMFamily;
import com.swirlds.demo.merkle.map.FCMTransactionPool;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.MapValueFCQ;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.expiration.ExpirationRecordEntry;
import com.swirlds.demo.platform.expiration.ExpirationUtils;
import com.swirlds.demo.platform.fs.stresstest.proto.AssortedAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.AssortedFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.BurnToken;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.CreateAccountFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.DeleteFCQNode;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.MintToken;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalance;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalanceFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferToken;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccount;
import com.swirlds.demo.platform.fs.stresstest.proto.UpdateAccountFCQ;
import com.swirlds.demo.platform.nft.Nft;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.demo.platform.nft.NftLedger;
import com.swirlds.demo.platform.nft.ReferenceNftLedger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;

public class FCMTransactionHandler {
    private static final Logger logger = LogManager.getLogger(FCMTransactionHandler.class);
    private static final Marker DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker DEMO_HANDLE_TX_TIME = MarkerManager.getMarker((String)"DEMO_HANDLE_TX_TIME");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private static final int HANDLE_LOG_DURATION = 1000;

    public static void performOperation(FCMTransaction fcmTransaction, PlatformTestingToolState state, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) throws IOException {
        long timeTakenMs;
        long startTime = System.nanoTime();
        PAYLOAD_TYPE type = null;
        FCMFamily fcmFamily = state.getFcmFamily();
        if (fcmFamily == null) {
            logger.info(DEMO_INFO, "FCMFamily is null");
            return;
        }
        if (fcmTransaction.hasCreateAccount()) {
            type = PAYLOAD_TYPE.TYPE_FCM_CREATE;
            FCMTransactionHandler.performCreateAccount(fcmTransaction.getCreateAccount(), fcmFamily.getMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasTransferBalance()) {
            type = PAYLOAD_TYPE.TYPE_FCM_TRANSFER;
            FCMTransactionHandler.performTransferBetweenAccounts(fcmTransaction.getTransferBalance(), fcmFamily.getMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasDeleteAccount()) {
            type = PAYLOAD_TYPE.TYPE_FCM_DELETE;
            FCMTransactionHandler.performDeleteAccount(fcmTransaction.getDeleteAccount(), fcmFamily.getMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasUpdateAccount()) {
            type = PAYLOAD_TYPE.TYPE_FCM_UPDATE;
            FCMTransactionHandler.performUpdateAccount(fcmTransaction.getUpdateAccount(), fcmFamily.getMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasAssortedAccount()) {
            type = PAYLOAD_TYPE.TYPE_FCM_ASSORTED;
            FCMTransactionHandler.performAssortedAccount(fcmTransaction.getAssortedAccount(), fcmFamily.getMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasAssortedFCQ()) {
            type = PAYLOAD_TYPE.TYPE_FCM_ASSORTED_FCQ;
            FCMTransactionHandler.performAssortedFCQ(fcmTransaction.getAssortedFCQ(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
        } else if (fcmTransaction.hasCreateAccountFCQ()) {
            type = PAYLOAD_TYPE.TYPE_FCM_CREATE_FCQ;
            FCMTransactionHandler.performCreateAccountFCQ(fcmTransaction.getCreateAccountFCQ(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
        } else if (fcmTransaction.hasDeleteFCQNode()) {
            type = PAYLOAD_TYPE.TYPE_FCM_DELETE_FCQ_NODE;
            FCMTransactionHandler.performDeleteFCQNode(fcmTransaction.getDeleteFCQNode(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasDeleteFCQ()) {
            type = PAYLOAD_TYPE.TYPE_FCM_DELETE_FCQ;
            FCMTransactionHandler.performDeleteFCQ(fcmTransaction.getDeleteFCQ(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType);
        } else if (fcmTransaction.hasUpdateAccountFCQ()) {
            type = PAYLOAD_TYPE.TYPE_FCM_UPDATE_FCQ;
            FCMTransactionHandler.performUpdateAccountFCQ(fcmTransaction.getUpdateAccountFCQ(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
        } else if (fcmTransaction.hasTransferBalanceFCQ()) {
            type = PAYLOAD_TYPE.TYPE_FCM_TRANSFER_FCQ;
            FCMTransactionHandler.performTransferFCQ(fcmTransaction.getTransferBalanceFCQ(), fcmFamily.getAccountFCQMap(), expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
        } else if (fcmTransaction.hasMintToken()) {
            type = PAYLOAD_TYPE.TYPE_MINT_TOKEN;
            FCMTransactionHandler.performMintToken(fcmTransaction.getMintToken(), state.getNftLedger(), state.getReferenceNftLedger(), expectedFCMFamily);
        } else if (fcmTransaction.hasTransferToken()) {
            type = PAYLOAD_TYPE.TYPE_TRANSFER_TOKEN;
            FCMTransactionHandler.performTransferToken(fcmTransaction.getTransferToken(), state.getNftLedger(), state.getReferenceNftLedger(), expectedFCMFamily);
        } else if (fcmTransaction.hasBurnToken()) {
            type = PAYLOAD_TYPE.TYPE_BURN_TOKEN;
            FCMTransactionHandler.performBurnToken(fcmTransaction.getBurnToken(), state.getNftLedger(), state.getReferenceNftLedger(), expectedFCMFamily);
        }
        if (type != null && (timeTakenMs = (System.nanoTime() - startTime) / 1000000L) > 1000L) {
            logger.info(DEMO_HANDLE_TX_TIME, "Time taken for handling {} is greater than {}ms: {} ms", (Object)type, (Object)1000, (Object)timeTakenMs);
        }
    }

    private static void performMintToken(MintToken mintToken, NftLedger nftLedger, ReferenceNftLedger referenceNftLedger, ExpectedFCMFamily expectedFCMFamily) {
        MapKey key = new MapKey(mintToken.getShardId(), mintToken.getRealmId(), mintToken.getAccountId());
        NftId nftId = new NftId(mintToken.getTokenShardId(), mintToken.getTokenRealmId(), mintToken.getTokenId());
        Nft token = new Nft();
        token.setMemo(mintToken.getMemo());
        token.setSerialNumber(mintToken.getSerialNumber());
        token.setShardNum(mintToken.getTokenShardId());
        token.setRealmNum(mintToken.getTokenRealmId());
        token.setTokenNum(mintToken.getTokenId());
        token.setMapKey(key);
        nftLedger.mintToken(key, nftId, token);
        expectedFCMFamily.addNftId(nftId);
        if (referenceNftLedger.isTokenTracked(nftId)) {
            referenceNftLedger.mintToken(key.copy(), nftId, token.deepCopy());
        }
    }

    private static void performBurnToken(BurnToken burnToken, NftLedger nftLedger, ReferenceNftLedger referenceNftLedger, ExpectedFCMFamily expectedFCMFamily) {
        NftId nftId = new NftId(burnToken.getTokenShardId(), burnToken.getTokenRealmId(), burnToken.getTokenId());
        if (!expectedFCMFamily.doesTokenWithIdExist(nftId)) {
            return;
        }
        nftLedger.burnToken(nftId);
        expectedFCMFamily.removeNftid(nftId);
        if (referenceNftLedger.isTokenTracked(nftId)) {
            referenceNftLedger.burnToken(nftId);
        }
    }

    private static void performTransferToken(TransferToken transferToken, NftLedger nftLedger, ReferenceNftLedger referenceNftLedger, ExpectedFCMFamily expectedFCMFamily) {
        MapKey toKey = new MapKey(transferToken.getToShardId(), transferToken.getToRealmId(), transferToken.getToAccountId());
        NftId nftId = new NftId(transferToken.getTokenShardId(), transferToken.getTokenRealmId(), transferToken.getTokenId());
        if (!expectedFCMFamily.doesTokenWithIdExist(nftId)) {
            return;
        }
        nftLedger.transferToken(nftId, toKey);
        if (referenceNftLedger.isTokenTracked(nftId)) {
            referenceNftLedger.transferToken(nftId, toKey.copy());
        }
    }

    private static void performCreateAccount(CreateAccount createAccount, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (map == null) {
            logger.error(ERROR, "accountMap is null");
            return;
        }
        MapKey key = new MapKey(createAccount.getShardID(), createAccount.getRealmID(), createAccount.getAccountID());
        MapValueData value = FCMTransactionHandler.createAccount(createAccount);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing create transaction for key {} with root hash {}, originId: {}", supplierArray);
        map.put((Object)key, (MerkleNode)value);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, value, TransactionState.HANDLED, TransactionType.Create, timestamp, originId, false);
    }

    private static void performTransferBetweenAccounts(TransferBalance transferBalance, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountMap is null");
            return;
        }
        MapKey fromKey = new MapKey(transferBalance.getFromShardID(), transferBalance.getFromRealmID(), transferBalance.getFromAccountID());
        MapKey toKey = new MapKey(transferBalance.getToShardID(), transferBalance.getToRealmID(), transferBalance.getToAccountID());
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = () -> fromKey;
        supplierArray[1] = () -> toKey;
        supplierArray[2] = () -> map.getRootHash();
        supplierArray[3] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing transfer transaction for keys {} and {} with root hash {}, originId: {}", supplierArray);
        long balance = transferBalance.getTransferAmount();
        Pair<MapValueData, MapValueData> newValuePair = FCMTransactionHandler.performTransfer(balance, fromKey, toKey, map, expectedFCMFamily);
        if (newValuePair == null) {
            return;
        }
        expectedFCMFamily.setLatestHandledStatusForKey(fromKey, entityType, (MapValue)newValuePair.left(), TransactionState.HANDLED, TransactionType.Transfer, timestamp, originId, false);
        expectedFCMFamily.setLatestHandledStatusForKey(toKey, entityType, (MapValue)newValuePair.right(), TransactionState.HANDLED, TransactionType.Transfer, timestamp, originId, false);
    }

    private static Pair<MapValueData, MapValueData> performTransfer(long balance, MapKey fromKey, MapKey toKey, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedMap) {
        if (FCMTransactionHandler.entityMissingFromMap(fromKey, map, expectedMap)) {
            return null;
        }
        if (FCMTransactionHandler.entityMissingFromMap(toKey, map, expectedMap)) {
            return null;
        }
        MapValueData valueFrom = (MapValueData)map.getForModify((Object)fromKey);
        MapValueData valueTo = (MapValueData)map.getForModify((Object)toKey);
        if (valueFrom == null || valueTo == null) {
            return null;
        }
        valueFrom.setBalance(valueFrom.getBalance() - balance);
        valueTo.setBalance(valueTo.getBalance() + balance);
        map.replace((Object)fromKey, (MerkleNode)valueFrom);
        map.replace((Object)toKey, (MerkleNode)valueTo);
        if (valueFrom.isImmutable() || valueTo.isImmutable()) {
            logger.error(FCMTransactionPool.DEMO_TRANSACTION_INFO, "VALUES ARE IMMUTABLE");
        }
        return Pair.of((Object)valueFrom, (Object)valueTo);
    }

    private static boolean entityMissingFromMap(MapKey key, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedMap) {
        if (!map.containsKey((Object)key)) {
            if (!expectedMap.entityHasBeenRemoved(key)) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Entity for {} was missing from map but was not deleted by prior transaction", (Object)key);
            }
            return true;
        }
        return false;
    }

    private static boolean entityMissingFromMapFCQ(MapKey key, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedMap) {
        if (!map.containsKey((Object)key)) {
            if (!expectedMap.entityHasBeenRemoved(key)) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Entity for {} was missing from map but was not deleted by prior transaction", (Object)key);
            }
            return true;
        }
        return false;
    }

    private static void performDeleteAccount(DeleteAccount deleteAccount, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountMap is null");
            return;
        }
        MapKey key = new MapKey(deleteAccount.getShardID(), deleteAccount.getRealmID(), deleteAccount.getAccountID());
        MapValue removedValue = (MapValue)map.remove((Object)key);
        boolean wasRemoved = removedValue != null;
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = () -> wasRemoved;
        supplierArray[1] = () -> key;
        supplierArray[2] = () -> map.getRootHash();
        supplierArray[3] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing delete transaction (removal={}) for key {} with root hash {}, originId: {}", supplierArray);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, null, TransactionState.HANDLED, TransactionType.Delete, timestamp, originId, false);
    }

    private static void performUpdateAccount(UpdateAccount updateAccount, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountMap is null");
            return;
        }
        MapKey key = new MapKey(updateAccount.getShardID(), updateAccount.getRealmID(), updateAccount.getAccountID());
        MapValueData value = (MapValueData)map.getForModify((Object)key);
        value.setBalance(updateAccount.getBalance());
        value.setSendThresholdValue(updateAccount.getSendThreshold());
        value.setReceiveThresholdValue(updateAccount.getReceiveThreshold());
        value.setReceiverSignatureRequired(updateAccount.getRequireSignature());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing update transaction for key {} with root hash {}, originId: {}", supplierArray);
        map.replace((Object)key, (MerkleNode)value);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, value, TransactionState.HANDLED, TransactionType.Update, timestamp, originId, false);
    }

    private static void performAssortedAccount(AssortedAccount assortedAccount, MerkleMap<MapKey, MapValueData> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) throws IOException {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountMap is null");
            return;
        }
        MapKey key = new MapKey(assortedAccount.getShardID(), assortedAccount.getRealmID(), assortedAccount.getAccountID());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing assorted transaction for key {} with root hash {}, originId: {}", supplierArray);
        switch (assortedAccount.getTxType()) {
            case Create: {
                CreateAccount createAccount = CreateAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
                FCMTransactionHandler.performCreateAccount(createAccount, map, expectedFCMFamily, originId, timestamp, entityType);
                break;
            }
            case Transfer: {
                TransferBalance transferBalance = TransferBalance.newBuilder().setFromShardID(key.getShardId()).setFromRealmID(key.getRealmId()).setFromAccountID(key.getAccountId()).setToShardID(assortedAccount.getShardIdTo()).setToRealmID(assortedAccount.getRealmIdTo()).setToAccountID(assortedAccount.getAccountIdTo()).setTransferAmount(assortedAccount.getAmountBalance()).build();
                FCMTransactionHandler.performTransferBetweenAccounts(transferBalance, map, expectedFCMFamily, originId, timestamp, entityType);
                break;
            }
            case Update: {
                UpdateAccount updateAccount = UpdateAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(assortedAccount.getAmountBalance()).setSendThreshold(assortedAccount.getSendThreshold()).setReceiveThreshold(assortedAccount.getReceiveThreshold()).setRequireSignature(assortedAccount.getRequireSignature()).build();
                FCMTransactionHandler.performUpdateAccount(updateAccount, map, expectedFCMFamily, originId, timestamp, entityType);
                break;
            }
            case Delete: {
                DeleteAccount deleteAccount = DeleteAccount.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
                FCMTransactionHandler.performDeleteAccount(deleteAccount, map, expectedFCMFamily, originId, timestamp, entityType);
            }
        }
    }

    private static void performAssortedFCQ(AssortedFCQ assortedFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) throws IOException {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountMap is null");
            return;
        }
        MapKey key = new MapKey(assortedFCQ.getShardID(), assortedFCQ.getRealmID(), assortedFCQ.getAccountID());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing assorted transaction for key {} with root hash {}, originId: {}", supplierArray);
        switch (assortedFCQ.getTxType()) {
            case FCQCreate: {
                CreateAccountFCQ createAccountFCQ = CreateAccountFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(assortedFCQ.getAmountBalance()).setIndex(assortedFCQ.getIndex()).setContent(assortedFCQ.getContent()).setInitialRecordNum(assortedFCQ.getInitialRecordNum()).build();
                FCMTransactionHandler.performCreateAccountFCQ(createAccountFCQ, map, expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
                break;
            }
            case FCQTransfer: {
                TransferBalanceFCQ transferBalanceFCQ = TransferBalanceFCQ.newBuilder().setFromShardID(key.getShardId()).setFromRealmID(key.getRealmId()).setFromAccountID(key.getAccountId()).setToShardID(assortedFCQ.getToShardID()).setToRealmID(assortedFCQ.getToRealmID()).setToAccountID(assortedFCQ.getToAccountID()).setTransferAmount(assortedFCQ.getAmountBalance()).setNewFromContent(assortedFCQ.getContent()).setNewToContent(assortedFCQ.getNewToContent()).build();
                FCMTransactionHandler.performTransferFCQ(transferBalanceFCQ, map, expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
                break;
            }
            case FCQUpdate: {
                UpdateAccountFCQ updateAccountFCQ = UpdateAccountFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).setBalance(assortedFCQ.getAmountBalance()).setIndex(assortedFCQ.getIndex()).setContent(assortedFCQ.getContent()).build();
                FCMTransactionHandler.performUpdateAccountFCQ(updateAccountFCQ, map, expectedFCMFamily, originId, timestamp, entityType, expirationTime, expirationQueue, accountsWithExpiringRecords);
                break;
            }
            case FCQDelete: {
                DeleteFCQ deleteFCQ = DeleteFCQ.newBuilder().setShardID(key.getShardId()).setRealmID(key.getRealmId()).setAccountID(key.getAccountId()).build();
                FCMTransactionHandler.performDeleteFCQ(deleteFCQ, map, expectedFCMFamily, originId, timestamp, entityType);
            }
        }
    }

    private static MapValueData createAccount(CreateAccount createAccount) {
        return new MapValueData(createAccount.getBalance(), createAccount.getSendThreshold(), createAccount.getReceiveThreshold(), createAccount.getRequireSignature(), createAccount.getUid());
    }

    private static void performTransferFCQ(TransferBalanceFCQ transferBalanceFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountFCQMap is null");
            return;
        }
        MapKey fromKey = new MapKey(transferBalanceFCQ.getFromShardID(), transferBalanceFCQ.getFromRealmID(), transferBalanceFCQ.getFromAccountID());
        MapKey toKey = new MapKey(transferBalanceFCQ.getToShardID(), transferBalanceFCQ.getToRealmID(), transferBalanceFCQ.getToAccountID());
        long transferAmount = transferBalanceFCQ.getTransferAmount();
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = () -> fromKey;
        supplierArray[1] = () -> toKey;
        supplierArray[2] = () -> map.getRootHash();
        supplierArray[3] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing transfer FCQ transaction for keys {} and {} with root hash {}, originId: {}", supplierArray);
        boolean isTransferred = FCMTransactionHandler.executeAccountFCQTransferred(transferAmount, transferBalanceFCQ.getNewFromContent().toByteArray(), fromKey, toKey, map, expectedFCMFamily, expirationTime, expirationQueue, accountsWithExpiringRecords);
        if (!isTransferred) {
            return;
        }
        MapValueFCQ newFromValue = (MapValueFCQ)map.get((Object)fromKey);
        MapValueFCQ newToValue = (MapValueFCQ)map.get((Object)toKey);
        expectedFCMFamily.setLatestHandledStatusForKey(fromKey, entityType, null, TransactionState.HANDLED, TransactionType.Transfer, timestamp, originId, false);
        expectedFCMFamily.setLatestHandledStatusForKey(toKey, entityType, null, TransactionState.HANDLED, TransactionType.Transfer, timestamp, originId, false);
    }

    private static boolean executeAccountFCQTransferred(long transferAmount, byte[] newContent, MapKey fromKey, MapKey toKey, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        if (FCMTransactionHandler.entityMissingFromMapFCQ(fromKey, map, expectedFCMFamily)) {
            return false;
        }
        if (FCMTransactionHandler.entityMissingFromMapFCQ(toKey, map, expectedFCMFamily)) {
            return false;
        }
        MapValueFCQ fromValue = (MapValueFCQ)map.getForModify((Object)fromKey);
        MapValueFCQ toValue = (MapValueFCQ)map.getForModify((Object)toKey);
        if (fromValue == null || toValue == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "FCQ Transfer Entities were checked for presence in map but one or more came back null");
            return false;
        }
        long newFromBalance = fromValue.getBalanceValue() - transferAmount;
        int fromRecordCount = fromValue.getRecordsSize();
        TransactionRecord newFromTransaction = new TransactionRecord((long)fromRecordCount, newFromBalance, newContent, expirationTime);
        fromValue.getRecords().add((FastCopyable)newFromTransaction);
        fromValue.setBalance(new MerkleLong(newFromBalance));
        map.replace((Object)fromKey, (MerkleNode)fromValue);
        ExpirationUtils.addRecordToExpirationQueue(newFromTransaction, fromKey, expirationQueue, accountsWithExpiringRecords);
        long newToBalance = toValue.getBalanceValue() + transferAmount;
        toValue.setBalance(new MerkleLong(newToBalance));
        map.replace((Object)toKey, (MerkleNode)toValue);
        return true;
    }

    private static void performUpdateAccountFCQ(UpdateAccountFCQ updateAccountFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountFCQMap is null");
            return;
        }
        MapKey key = new MapKey(updateAccountFCQ.getShardID(), updateAccountFCQ.getRealmID(), updateAccountFCQ.getAccountID());
        TransactionRecord transactionRecord = new TransactionRecord(updateAccountFCQ.getIndex(), updateAccountFCQ.getBalance(), updateAccountFCQ.getContent().toByteArray(), expirationTime);
        long balance = updateAccountFCQ.getBalance();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing update FCQ transaction for key {} with root hash {}, originId: {}", supplierArray);
        boolean isUpdated = FCMTransactionHandler.executeAccountFCQUpdated(balance, key, transactionRecord, map, expirationQueue, accountsWithExpiringRecords);
        if (!isUpdated) {
            return;
        }
        MapValueFCQ value = (MapValueFCQ)map.get((Object)key);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, null, TransactionState.HANDLED, TransactionType.Update, timestamp, originId, false);
    }

    private static boolean executeAccountFCQUpdated(long balance, MapKey key, TransactionRecord transactionRecord, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        MapValueFCQ value = (MapValueFCQ)map.getForModify((Object)key);
        if (value == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "FCQ: from Key {} for UpdateFCQ doesn't exist", new Supplier[]{() -> key});
            return false;
        }
        value.getRecords().add((FastCopyable)transactionRecord);
        value.setBalance(new MerkleLong(balance));
        map.replace((Object)key, (MerkleNode)value);
        ExpirationUtils.addRecordToExpirationQueue(transactionRecord, key, expirationQueue, accountsWithExpiringRecords);
        return true;
    }

    private static void performDeleteFCQNode(DeleteFCQNode deleteFCQNode, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountFCQMap is null");
            return;
        }
        MapKey key = new MapKey(deleteFCQNode.getShardID(), deleteFCQNode.getRealmID(), deleteFCQNode.getAccountID());
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing delete FCQ Node transaction for key {}, originId: {}", new Supplier[]{() -> key, () -> originId});
        int index = (int)deleteFCQNode.getIndex();
        boolean isDeleted = FCMTransactionHandler.isFCQRecordDeleted(index, key, map);
        if (!isDeleted) {
            return;
        }
        MapValueFCQ newValue = (MapValueFCQ)map.get((Object)key);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, null, TransactionState.HANDLED, TransactionType.Update, timestamp, originId, false);
    }

    private static void performDeleteFCQ(DeleteFCQ deleteFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> accountFCQMap, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType) {
        if (accountFCQMap == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountFCQMap is null");
            return;
        }
        MapKey key = new MapKey(deleteFCQ.getShardID(), deleteFCQ.getRealmID(), deleteFCQ.getAccountID());
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing delete FCQ transaction for key {}, originId: {}", new Supplier[]{() -> key, () -> originId});
        MapValue removedValue = (MapValue)accountFCQMap.remove((Object)key);
        boolean wasRemoved = removedValue != null;
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = () -> wasRemoved;
        supplierArray[1] = () -> key;
        supplierArray[2] = () -> accountFCQMap.getRootHash();
        supplierArray[3] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing delete FCQ transaction (removal={}) for key {} with root hash {}, originId: {}", supplierArray);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, null, TransactionState.HANDLED, TransactionType.Delete, timestamp, originId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFCQRecordDeleted(int index, MapKey key, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map) {
        MapValueFCQ value;
        block7: {
            int recordsSize;
            block6: {
                block5: {
                    boolean bl;
                    value = (MapValueFCQ)map.getForModify((Object)key);
                    try {
                        if (value != null) break block5;
                        logger.error(LogMarker.EXCEPTION.getMarker(), "FCQ: Key {} for delete doesn't exist", new Supplier[]{() -> key});
                        bl = false;
                        if (value == null) return bl;
                    }
                    catch (Throwable throwable) {
                        if (value == null) throw throwable;
                        map.replace((Object)key, (MerkleNode)value);
                        throw throwable;
                    }
                    map.replace((Object)key, value);
                    return bl;
                }
                recordsSize = value.getRecordsSize();
                if (recordsSize != 0) break block6;
                logger.info(FCMTransactionPool.DEMO_TRANSACTION_INFO, "FCQ: Key {} has an empty records when deleting index {}", (Object)key, (Object)index);
                boolean bl = false;
                if (value == null) return bl;
                map.replace((Object)key, value);
                return bl;
            }
            if (index < recordsSize) break block7;
            logger.error(LogMarker.EXCEPTION.getMarker(), "FCQ: Key {} for delete at index {} is out of bounds for list size {}", (Object)key, (Object)index, (Object)recordsSize);
            boolean bl = false;
            if (value == null) return bl;
            map.replace((Object)key, value);
            return bl;
        }
        value = value.deleteFirst();
        if (value == null) return true;
        map.replace((Object)key, value);
        return true;
    }

    private static void performCreateAccountFCQ(CreateAccountFCQ createAccountFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, ExpectedFCMFamily expectedFCMFamily, long originId, long timestamp, EntityType entityType, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        MapKey key = new MapKey(createAccountFCQ.getShardID(), createAccountFCQ.getRealmID(), createAccountFCQ.getAccountID());
        if (map == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "accountFCQMap is null");
            return;
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> key;
        supplierArray[1] = () -> map.getRootHash();
        supplierArray[2] = () -> originId;
        logger.trace(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Processing create FCQ transaction for key {} with root hash {}, originId: {}", supplierArray);
        boolean isCreated = FCMTransactionHandler.executeAccountFCQCreated(createAccountFCQ, map, key, expirationTime, expirationQueue, accountsWithExpiringRecords);
        if (!isCreated) {
            return;
        }
        MapValueFCQ value = (MapValueFCQ)map.get((Object)key);
        expectedFCMFamily.setLatestHandledStatusForKey(key, entityType, value, TransactionState.HANDLED, TransactionType.Create, timestamp, originId, false);
    }

    private static boolean executeAccountFCQCreated(CreateAccountFCQ createAccountFCQ, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> map, MapKey key, long expirationTime, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        MapValueFCQ<TransactionRecord> value = MapValueFCQ.newBuilder().setIndex(createAccountFCQ.getIndex()).setBalance(createAccountFCQ.getBalance()).setContent(createAccountFCQ.getContent().toByteArray()).setMapKey(key).setExpirationQueue(expirationQueue).setExpirationTime(expirationTime).setAccountsWithExpiringRecords(accountsWithExpiringRecords).build();
        if (key == null || value == null) {
            return false;
        }
        long initialRecordNum = createAccountFCQ.getInitialRecordNum();
        byte[] content = new byte[createAccountFCQ.getContent().toByteArray().length];
        ArrayList<TransactionRecord> records = new ArrayList<TransactionRecord>();
        int i = 1;
        while ((long)i < initialRecordNum) {
            TransactionRecord transactionRecord = new TransactionRecord((long)i, createAccountFCQ.getBalance(), content, expirationTime);
            records.add(transactionRecord);
            ++i;
        }
        value = value.addRecords(createAccountFCQ.getBalance(), records, key, expirationQueue, accountsWithExpiringRecords);
        map.put((Object)key, value);
        int recordSize = value.getRecordsSize();
        if (initialRecordNum != (long)recordSize) {
            logger.info(FCMTransactionPool.DEMO_TRANSACTION_INFO, "Error when processing create FCQ transaction for MapValueFCQ, key {}. expectedRecordNum {}, actualRecordNum {}", new Supplier[]{() -> key, () -> initialRecordNum, () -> recordSize});
        }
        return true;
    }
}

