/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.PlatformTestingToolConsensusStateEventHandler;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.PttTransactionPool;
import com.swirlds.demo.platform.SubmitConfig;
import com.swirlds.demo.platform.SuperConfig;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.model.node.NodeId;

public class AppClient
extends Thread {
    Platform platform;
    NodeId selfId;
    String myName;
    byte[] submittedBytes = null;
    PayloadCfgSimple config;
    private PttTransactionPool pttTransactionPool;
    private TransactionSubmitter submitter;
    private ExpectedFCMFamily expectedFCMFamily;

    AppClient(@NonNull Platform platform, @NonNull NodeId selfId, @NonNull SuperConfig currentConfig, @NonNull String myName, @NonNull PlatformTestingToolConsensusStateEventHandler stateEventHandler) {
        this.platform = Objects.requireNonNull(platform, "platform must not be null");
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        Objects.requireNonNull(currentConfig, "currentConfig must not be null");
        this.myName = Objects.requireNonNull(myName, "myName must not be null");
        PayloadCfgSimple pConfig = currentConfig.getPayloadConfig();
        PayloadConfig payloadConfig = PayloadConfig.builder().setAppendSig(pConfig.isAppendSig()).setInsertSeq(pConfig.isInsertSeq()).setVariedSize(pConfig.isVariedSize()).setPayloadByteSize(pConfig.getPayloadByteSize()).setMaxByteSize(pConfig.getMaxByteSize()).setType(pConfig.getType()).setDistribution(pConfig.getDistribution()).build();
        SubmitConfig submitConfig = currentConfig.getSubmitConfig();
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            this.submitter = new TransactionSubmitter(submitConfig, stateEventHandler.getControlQuorum());
            this.expectedFCMFamily = state.getStateExpectedMap();
        }
        this.pttTransactionPool = new PttTransactionPool(platform, platform.getSelfId().id(), payloadConfig, myName, currentConfig.getFcmConfig(), currentConfig.getVirtualMerkleConfig(), currentConfig.getFreezeConfig(), currentConfig.getTransactionPoolConfig(), this.submitter, this.expectedFCMFamily);
        this.config = pConfig;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }
}

