/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.gui;

import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.consensus.SyntheticSnapshot;
import com.swirlds.platform.event.orphan.DefaultOrphanBuffer;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import com.swirlds.platform.gui.BranchedEventMetadata;
import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.hashgraph.internal.StandardGuiSource;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.ForkingEventSource;
import com.swirlds.platform.test.fixtures.gui.GeneratorEventProvider;
import com.swirlds.platform.test.fixtures.gui.GuiEventProvider;
import com.swirlds.platform.test.fixtures.gui.HashgraphGuiRunner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;

public class TestGuiSource {
    private final GuiEventProvider eventProvider;
    private final HashgraphGuiSource guiSource;
    private ConsensusSnapshot savedSnapshot;
    private final GuiEventStorage eventStorage;
    private final Map<GossipEvent, BranchedEventMetadata> eventsToBranchMetadata = new HashMap<GossipEvent, BranchedEventMetadata>();
    private final OrphanBuffer orphanBuffer;

    public TestGuiSource(@NonNull PlatformContext platformContext, @NonNull AddressBook addressBook, @NonNull GuiEventProvider eventProvider) {
        this.eventStorage = new GuiEventStorage(platformContext.getConfiguration(), addressBook);
        this.guiSource = new StandardGuiSource(addressBook, this.eventStorage);
        this.eventProvider = eventProvider;
        this.orphanBuffer = new DefaultOrphanBuffer(platformContext.getConfiguration(), platformContext.getMetrics(), (IntakeEventCounter)new NoOpIntakeEventCounter());
    }

    public void runGui() {
        HashgraphGuiRunner.runHashgraphGui(this.guiSource, this.controls());
    }

    public void generateEvents(int numEvents) {
        List<PlatformEvent> rawEvents = this.eventProvider.provideEvents(numEvents);
        List events = rawEvents.stream().map(arg_0 -> ((OrphanBuffer)this.orphanBuffer).handleEvent(arg_0)).flatMap(Collection::stream).toList();
        Map<PlatformEvent, Integer> eventToBranchIndex = this.getEventToBranchIndex();
        for (PlatformEvent event : events) {
            if (!eventToBranchIndex.isEmpty() && eventToBranchIndex.containsKey(event)) {
                BranchedEventMetadata branchedEventMetadata = new BranchedEventMetadata(eventToBranchIndex.get(event), Long.valueOf(event.getNGen()));
                this.eventsToBranchMetadata.put(event.getGossipEvent(), branchedEventMetadata);
            }
            this.eventStorage.handlePreconsensusEvent(event);
        }
        this.eventStorage.setBranchedEventsMetadata(this.eventsToBranchMetadata);
    }

    @NonNull
    public JPanel controls() {
        JLabel fameDecidedBelow = new JLabel("N/A");
        Runnable updateFameDecidedBelow = () -> fameDecidedBelow.setText("fame decided below: " + this.eventStorage.getConsensus().getFameDecidedBelow());
        updateFameDecidedBelow.run();
        JButton nextEvent = new JButton("Next events");
        int defaultNumEvents = 10;
        boolean numEventsMinimum = true;
        boolean numEventsStep = true;
        JSpinner numEvents = new JSpinner(new SpinnerNumberModel((Number)10, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), (Number)1));
        nextEvent.addActionListener(e -> {
            int n;
            Object patt0$temp = numEvents.getValue();
            if (patt0$temp instanceof Integer) {
                Integer value = (Integer)patt0$temp;
                n = value;
            } else {
                n = 10;
            }
            List<PlatformEvent> rawEvents = this.eventProvider.provideEvents(n);
            List events = rawEvents.stream().map(arg_0 -> ((OrphanBuffer)this.orphanBuffer).handleEvent(arg_0)).flatMap(Collection::stream).toList();
            Map<PlatformEvent, Integer> eventToBranchIndex = this.getEventToBranchIndex();
            for (PlatformEvent event : events) {
                if (!eventToBranchIndex.isEmpty() && eventToBranchIndex.containsKey(event)) {
                    BranchedEventMetadata branchedEventMetadata = new BranchedEventMetadata(eventToBranchIndex.get(event), Long.valueOf(event.getNGen()));
                    this.eventsToBranchMetadata.put(event.getGossipEvent(), branchedEventMetadata);
                }
                this.eventStorage.handlePreconsensusEvent(event);
            }
            this.eventStorage.setBranchedEventsMetadata(this.eventsToBranchMetadata);
            updateFameDecidedBelow.run();
        });
        JButton reset = new JButton("Reset");
        reset.addActionListener(e -> {
            this.eventProvider.reset();
            this.eventStorage.handleSnapshotOverride(SyntheticSnapshot.getGenesisSnapshot());
            updateFameDecidedBelow.run();
        });
        JButton printLastSnapshot = new JButton("Print last snapshot");
        printLastSnapshot.addActionListener(e -> {
            ConsensusRound round = this.eventStorage.getLastConsensusRound();
            if (round == null) {
                System.out.println("No consensus rounds");
            } else {
                System.out.println(round.getSnapshot());
            }
        });
        JButton saveLastSnapshot = new JButton("Save last snapshot");
        saveLastSnapshot.addActionListener(e -> {
            ConsensusRound round = this.eventStorage.getLastConsensusRound();
            if (round == null) {
                System.out.println("No consensus rounds");
            } else {
                this.savedSnapshot = round.getSnapshot();
            }
        });
        JButton loadSavedSnapshot = new JButton("Load saved snapshot");
        loadSavedSnapshot.addActionListener(e -> {
            if (this.savedSnapshot == null) {
                System.out.println("No saved snapshot");
                return;
            }
            this.eventStorage.handleSnapshotOverride(this.savedSnapshot);
        });
        JPanel controls = new JPanel(new FlowLayout());
        controls.add(nextEvent);
        controls.add(numEvents);
        controls.add(reset);
        controls.add(fameDecidedBelow);
        controls.add(printLastSnapshot);
        controls.add(saveLastSnapshot);
        controls.add(loadSavedSnapshot);
        return controls;
    }

    public void loadSnapshot(ConsensusSnapshot snapshot) {
        System.out.println("Loading snapshot for round: " + snapshot.round());
        this.eventStorage.handleSnapshotOverride(snapshot);
    }

    public GuiEventStorage getEventStorage() {
        return this.eventStorage;
    }

    private Map<PlatformEvent, Integer> getEventToBranchIndex() {
        HashMap<PlatformEvent, Integer> eventToBranchIndex = new HashMap<PlatformEvent, Integer>();
        if (this.eventProvider instanceof GeneratorEventProvider) {
            ArrayList<ForkingEventSource> forkingEventSources = new ArrayList<ForkingEventSource>();
            for (NodeId nodeId : this.guiSource.getAddressBook().getNodeIdSet()) {
                EventSource eventSource = ((GeneratorEventProvider)this.eventProvider).getNodeSource(nodeId);
                if (!(eventSource instanceof ForkingEventSource)) continue;
                ForkingEventSource forkingEventSource = (ForkingEventSource)eventSource;
                forkingEventSources.add(forkingEventSource);
                List<LinkedList<EventImpl>> branches = forkingEventSource.getBranches();
                for (int i = 0; i < branches.size(); ++i) {
                    List branch = branches.get(i);
                    for (EventImpl event : branch) {
                        eventToBranchIndex.put(event.getBaseEvent(), i);
                    }
                }
            }
        }
        return eventToBranchIndex;
    }
}

