/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Comparator;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class HapiUtils {
    private static final String ALPHA_PREFIX = "alpha.";
    private static final int ALPHA_PREFIX_LENGTH = "alpha.".length();
    public static final Comparator<SemanticVersion> SEMANTIC_VERSION_COMPARATOR = Comparator.nullsFirst(Comparator.comparingInt(SemanticVersion::major).thenComparingInt(SemanticVersion::minor).thenComparingInt(SemanticVersion::patch).thenComparingInt(semVer -> HapiUtils.parsedAlphaIntOrMaxValue(semVer.pre())).thenComparingInt(semVer -> HapiUtils.parsedIntOrZero(semVer.build())));

    private static int parsedAlphaIntOrMaxValue(@NonNull String s) {
        if (s.isBlank() || !s.startsWith(ALPHA_PREFIX)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(s.substring(ALPHA_PREFIX_LENGTH));
        }
        catch (NumberFormatException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    private static int parsedIntOrZero(@NonNull String s) {
        if (s.isBlank() || "0".equals(s)) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    public static SemanticVersion deserializeSemVer(SerializableDataInputStream in) throws IOException {
        SemanticVersion.Builder ans = SemanticVersion.newBuilder();
        ans.major(in.readInt()).minor(in.readInt()).patch(in.readInt());
        if (in.readBoolean()) {
            ans.pre(in.readNormalisedString(Integer.MAX_VALUE));
        }
        if (in.readBoolean()) {
            ans.build(in.readNormalisedString(Integer.MAX_VALUE));
        }
        return ans.build();
    }

    public static void serializeSemVer(SemanticVersion semVer, SerializableDataOutputStream out) throws IOException {
        out.writeInt(semVer.major());
        out.writeInt(semVer.minor());
        out.writeInt(semVer.patch());
        HapiUtils.serializeIfUsed(semVer.pre(), out);
        HapiUtils.serializeIfUsed(semVer.build(), out);
    }

    private static void serializeIfUsed(String semVerPart, SerializableDataOutputStream out) throws IOException {
        if (semVerPart.isBlank()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeNormalisedString(semVerPart);
        }
    }

    public static String asAccountString(AccountID accountID) {
        return String.format("%d.%d.%d", accountID.shardNum(), accountID.realmNum(), accountID.accountNum());
    }
}

