/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.EventStreamCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.report.EventStreamMultiNodeReport;
import com.swirlds.platform.event.report.EventStreamReport;
import com.swirlds.platform.event.report.EventStreamScanner;
import com.swirlds.platform.recovery.internal.EventStreamLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamRoundLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamTimestampLowerBound;
import com.swirlds.platform.util.BootstrapUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="info", mixinStandardHelpOptions=true, description={"Read event stream files and print an informational report."})
@SubcommandOf(value=EventStreamCommand.class)
public final class EventStreamInfoCommand
extends AbstractCommand {
    private static final Logger logger = LogManager.getLogger(EventStreamInfoCommand.class);
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private Path eventStreamDirectory;
    private Instant timestampBound = Instant.MIN;
    private long roundBound = -1L;
    private Duration granularity = Duration.ofSeconds(10L);
    private boolean multiNodeReport = false;

    @CommandLine.Parameters(description={"The path to a directory tree containing event stream files."})
    private void setEventStreamDirectory(Path eventStreamDirectory) {
        this.eventStreamDirectory = this.pathMustExist(eventStreamDirectory.toAbsolutePath());
    }

    @CommandLine.Option(names={"-f", "--first-round"}, description={"The first round to be considered in the event stream."})
    private void setFirstRound(long firstRound) {
        this.roundBound = firstRound;
    }

    @CommandLine.Option(names={"-t", "--timestamp"}, description={"The minimum timestamp to be considered in the event stream. The format is \"yyyy-MM-dd HH:mm:ss\"."})
    private void setTimestamp(@NonNull String timestamp) {
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        try {
            this.timestampBound = formatter.parse((CharSequence)timestamp, Instant::from);
        }
        catch (DateTimeParseException e) {
            this.timestampBound = Instant.parse(timestamp);
        }
    }

    @CommandLine.Option(names={"-g", "--granularity"}, description={"The temporal granularity of the data report, in seconds."})
    private void setGranularityInSeconds(long granularityInSeconds) {
        if (granularityInSeconds < 1L) {
            throw this.buildParameterException("Granularity must be strictly greater than 1");
        }
        this.granularity = Duration.ofSeconds(granularityInSeconds);
    }

    @CommandLine.Option(names={"-m", "--multi-node-report"}, description={"Generate a separate report for each direct child of the specified directory, as well as a summary report."})
    private void requestMultiNodeReport(boolean multiNodeReport) {
        this.multiNodeReport = multiNodeReport;
    }

    private EventStreamInfoCommand() {
    }

    @Nullable
    private EventStreamReport generateReport(@NonNull Path directory, @NonNull EventStreamLowerBound bound) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(bound);
        try {
            return new EventStreamScanner(directory, bound, this.granularity, true).createReport();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to generate event stream report", e);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private void writeNodeReportToFile(@NonNull Path nodeDirectory, @NonNull EventStreamReport nodeReport) {
        Path reportFile = nodeDirectory.resolve("event-stream-report.txt");
        try {
            Files.writeString(reportFile, (CharSequence)nodeReport.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write report to file", e);
        }
    }

    private void generateMultiNodeReport(@NonNull EventStreamLowerBound bound) throws IOException {
        Objects.requireNonNull(bound);
        EventStreamMultiNodeReport multiReport = new EventStreamMultiNodeReport();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.eventStreamDirectory);){
            stream.forEach(streamElement -> {
                if (!Files.isDirectory(streamElement, new LinkOption[0])) {
                    return;
                }
                Path directory = streamElement.normalize();
                EventStreamReport individualReport = this.generateReport(directory, bound);
                if (individualReport == null) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "No event stream files found in `{}`", (Object)directory);
                    return;
                }
                multiReport.addIndividualReport(directory, individualReport);
                this.writeNodeReportToFile(directory, individualReport);
            });
        }
        try {
            System.out.println(multiReport);
        }
        catch (NoSuchElementException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "No event stream files found in any child directory of `{}`", (Object)this.eventStreamDirectory);
        }
    }

    public Integer call() throws Exception {
        BootstrapUtils.setupConstructableRegistry();
        if (this.roundBound > 0L && !Instant.MIN.equals(this.timestampBound)) {
            throw this.buildParameterException("Cannot set both round and timestamp");
        }
        EventStreamLowerBound bound = this.roundBound > 0L ? new EventStreamRoundLowerBound(this.roundBound) : (!Instant.MIN.equals(this.timestampBound) ? new EventStreamTimestampLowerBound(this.timestampBound) : EventStreamLowerBound.UNBOUNDED);
        if (this.multiNodeReport) {
            this.generateMultiNodeReport(bound);
        } else {
            EventStreamReport report = this.generateReport(this.eventStreamDirectory, bound);
            if (report == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No event stream files found in `{}`", (Object)this.eventStreamDirectory);
            } else {
                System.out.println(report);
            }
        }
        return 0;
    }
}

