/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.test.fixtures.FunctionReadableSingletonState;
import com.swirlds.state.test.fixtures.FunctionWritableSingletonState;
import com.swirlds.state.test.fixtures.ListReadableQueueState;
import com.swirlds.state.test.fixtures.ListWritableQueueState;
import com.swirlds.state.test.fixtures.MapReadableKVState;
import com.swirlds.state.test.fixtures.MapWritableKVState;
import com.swirlds.state.test.fixtures.TestBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.ArgumentMatchers;

public class StateTestBase
extends TestBase {
    public static final SemanticVersion TEST_VERSION = SemanticVersion.newBuilder().major(1).build();
    public static final String FIRST_SERVICE = "First-Service";
    public static final String SECOND_SERVICE = "Second-Service";
    public static final String UNKNOWN_SERVICE = "Bogus-Service";
    protected static final String UNKNOWN_STATE_KEY = "BOGUS_STATE_KEY";
    protected static final ProtoBytes UNKNOWN_KEY = new ProtoBytes(Bytes.wrap((String)"BOGUS_KEY"));
    protected static final String FRUIT_SERVICE_NAME = "Plants";
    protected static final String FRUIT_STATE_KEY = "FRUIT";
    protected static final int FRUIT_STATE_ID = 3;
    protected static final String ANIMAL_SERVICE_NAME = "Organisms";
    protected static final String ANIMAL_STATE_KEY = "ANIMAL";
    protected static final int ANIMAL_STATE_ID = 16;
    protected static final String SPACE_SERVICE_NAME = "Universe";
    protected static final String SPACE_STATE_KEY = "SPACE";
    protected static final int SPACE_STATE_ID = 1;
    protected static final String STEAM_SERVICE_NAME = "Learning";
    protected static final String STEAM_STATE_KEY = "STEAM";
    protected static final int STEAM_STATE_ID = 10001;
    public static final String COUNTRY_SERVICE_NAME = "Planets";
    public static final String COUNTRY_STATE_KEY = "COUNTRY";
    protected static final int COUNTRY_STATE_ID = 11;
    protected static final ProtoBytes A_KEY = StateTestBase.toProtoBytes("A");
    protected static final ProtoBytes B_KEY = StateTestBase.toProtoBytes("B");
    protected static final ProtoBytes C_KEY = StateTestBase.toProtoBytes("C");
    protected static final ProtoBytes D_KEY = StateTestBase.toProtoBytes("D");
    protected static final ProtoBytes E_KEY = StateTestBase.toProtoBytes("E");
    protected static final ProtoBytes F_KEY = StateTestBase.toProtoBytes("F");
    protected static final ProtoBytes G_KEY = StateTestBase.toProtoBytes("G");
    protected static final ProtoBytes APPLE = StateTestBase.toProtoBytes("Apple");
    protected static final ProtoBytes ACAI = StateTestBase.toProtoBytes("Acai");
    protected static final ProtoBytes BANANA = StateTestBase.toProtoBytes("Banana");
    protected static final ProtoBytes BLACKBERRY = StateTestBase.toProtoBytes("BlackBerry");
    protected static final ProtoBytes BLUEBERRY = StateTestBase.toProtoBytes("BlueBerry");
    protected static final ProtoBytes CHERRY = StateTestBase.toProtoBytes("Cherry");
    protected static final ProtoBytes CRANBERRY = StateTestBase.toProtoBytes("Cranberry");
    protected static final ProtoBytes DATE = StateTestBase.toProtoBytes("Date");
    protected static final ProtoBytes DRAGONFRUIT = StateTestBase.toProtoBytes("DragonFruit");
    protected static final ProtoBytes EGGPLANT = StateTestBase.toProtoBytes("Eggplant");
    protected static final ProtoBytes ELDERBERRY = StateTestBase.toProtoBytes("ElderBerry");
    protected static final ProtoBytes FIG = StateTestBase.toProtoBytes("Fig");
    protected static final ProtoBytes FEIJOA = StateTestBase.toProtoBytes("Feijoa");
    protected static final ProtoBytes GRAPE = StateTestBase.toProtoBytes("Grape");
    protected static final ProtoBytes AARDVARK = StateTestBase.toProtoBytes("Aardvark");
    protected static final ProtoBytes BEAR = StateTestBase.toProtoBytes("Bear");
    protected static final ProtoBytes CUTTLEFISH = StateTestBase.toProtoBytes("Cuttlefish");
    protected static final ProtoBytes DOG = StateTestBase.toProtoBytes("Dog");
    protected static final ProtoBytes EMU = StateTestBase.toProtoBytes("Emu");
    protected static final ProtoBytes FOX = StateTestBase.toProtoBytes("Fox");
    protected static final ProtoBytes GOOSE = StateTestBase.toProtoBytes("Goose");
    protected static final ProtoBytes ASTRONAUT = StateTestBase.toProtoBytes("Astronaut");
    protected static final ProtoBytes BLASTOFF = StateTestBase.toProtoBytes("Blastoff");
    protected static final ProtoBytes COMET = StateTestBase.toProtoBytes("Comet");
    protected static final ProtoBytes DRACO = StateTestBase.toProtoBytes("Draco");
    protected static final ProtoBytes EXOPLANET = StateTestBase.toProtoBytes("Exoplanet");
    protected static final ProtoBytes FORCE = StateTestBase.toProtoBytes("Force");
    protected static final ProtoBytes GRAVITY = StateTestBase.toProtoBytes("Gravity");
    protected static final ProtoBytes ART = StateTestBase.toProtoBytes("Art");
    protected static final ProtoBytes BIOLOGY = StateTestBase.toProtoBytes("Biology");
    protected static final ProtoBytes CHEMISTRY = StateTestBase.toProtoBytes("Chemistry");
    protected static final ProtoBytes DISCIPLINE = StateTestBase.toProtoBytes("Discipline");
    protected static final ProtoBytes ECOLOGY = StateTestBase.toProtoBytes("Ecology");
    protected static final ProtoBytes FIELDS = StateTestBase.toProtoBytes("Fields");
    protected static final ProtoBytes GEOMETRY = StateTestBase.toProtoBytes("Geometry");
    protected static final ProtoBytes AUSTRALIA = StateTestBase.toProtoBytes("Australia");
    protected static final ProtoBytes BRAZIL = StateTestBase.toProtoBytes("Brazil");
    protected static final ProtoBytes CHAD = StateTestBase.toProtoBytes("Chad");
    protected static final ProtoBytes DENMARK = StateTestBase.toProtoBytes("Denmark");
    protected static final ProtoBytes ESTONIA = StateTestBase.toProtoBytes("Estonia");
    protected static final ProtoBytes FRANCE = StateTestBase.toProtoBytes("France");
    protected static final ProtoBytes GHANA = StateTestBase.toProtoBytes("Ghana");

    @NonNull
    protected MapReadableKVState<ProtoBytes, ProtoBytes> readableFruitState() {
        return MapReadableKVState.builder(FRUIT_SERVICE_NAME, FRUIT_STATE_KEY).value(A_KEY, APPLE).value(B_KEY, BANANA).value(C_KEY, CHERRY).value(D_KEY, DATE).value(E_KEY, EGGPLANT).value(F_KEY, FIG).value(G_KEY, GRAPE).build();
    }

    @NonNull
    protected MapWritableKVState<ProtoBytes, ProtoBytes> writableFruitState() {
        return MapWritableKVState.builder(FRUIT_SERVICE_NAME, FRUIT_STATE_KEY).value(A_KEY, APPLE).value(B_KEY, BANANA).value(C_KEY, CHERRY).value(D_KEY, DATE).value(E_KEY, EGGPLANT).value(F_KEY, FIG).value(G_KEY, GRAPE).build();
    }

    @NonNull
    protected MapReadableKVState<ProtoBytes, ProtoBytes> readableAnimalState() {
        return MapReadableKVState.builder(ANIMAL_SERVICE_NAME, ANIMAL_STATE_KEY).value(A_KEY, AARDVARK).value(B_KEY, BEAR).value(C_KEY, CUTTLEFISH).value(D_KEY, DOG).value(E_KEY, EMU).value(F_KEY, FOX).value(G_KEY, GOOSE).build();
    }

    @NonNull
    protected MapWritableKVState<ProtoBytes, ProtoBytes> writableAnimalState() {
        return MapWritableKVState.builder(ANIMAL_SERVICE_NAME, ANIMAL_STATE_KEY).value(A_KEY, AARDVARK).value(B_KEY, BEAR).value(C_KEY, CUTTLEFISH).value(D_KEY, DOG).value(E_KEY, EMU).value(F_KEY, FOX).value(G_KEY, GOOSE).build();
    }

    @NonNull
    protected ReadableSingletonState<ProtoBytes> readableSpaceState() {
        return new FunctionReadableSingletonState<ProtoBytes>(SPACE_SERVICE_NAME, SPACE_STATE_KEY, () -> ASTRONAUT);
    }

    @NonNull
    protected WritableSingletonState<ProtoBytes> writableSpaceState() {
        AtomicReference<ProtoBytes> backingValue = new AtomicReference<ProtoBytes>(ASTRONAUT);
        return new FunctionWritableSingletonState<ProtoBytes>(SPACE_SERVICE_NAME, SPACE_STATE_KEY, backingValue::get, backingValue::set);
    }

    @NonNull
    protected ListReadableQueueState<ProtoBytes> readableSTEAMState() {
        return ListReadableQueueState.builder(STEAM_STATE_KEY, STEAM_SERVICE_NAME).value(ART).value(BIOLOGY).value(CHEMISTRY).value(DISCIPLINE).value(ECOLOGY).value(FIELDS).value(GEOMETRY).build();
    }

    @NonNull
    protected ListWritableQueueState<ProtoBytes> writableSTEAMState() {
        return ListWritableQueueState.builder(STEAM_SERVICE_NAME, STEAM_STATE_KEY).value(ART).value(BIOLOGY).value(CHEMISTRY).value(DISCIPLINE).value(ECOLOGY).value(FIELDS).value(GEOMETRY).build();
    }

    @NonNull
    protected ReadableSingletonState<ProtoBytes> readableCountryState() {
        return new FunctionReadableSingletonState<ProtoBytes>(COUNTRY_SERVICE_NAME, COUNTRY_STATE_KEY, () -> AUSTRALIA);
    }

    @NonNull
    protected WritableSingletonState<ProtoBytes> writableCountryState() {
        AtomicReference<ProtoBytes> backingValue = new AtomicReference<ProtoBytes>(AUSTRALIA);
        return new FunctionWritableSingletonState<ProtoBytes>(COUNTRY_SERVICE_NAME, COUNTRY_STATE_KEY, backingValue::get, backingValue::set);
    }

    protected SemanticVersion version(int major, int minor, int patch) {
        return new SemanticVersion(major, minor, patch, null, null);
    }

    protected static ProtoBytes anyProtoBytes() {
        return (ProtoBytes)ArgumentMatchers.any(ProtoBytes.class);
    }

    protected static ProtoBytes toProtoBytes(String value) {
        return new ProtoBytes(Bytes.wrap((String)value));
    }
}

