/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.resubmitter;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;

public class TransactionResubmitterMetrics {
    private static final SpeedometerMetric.Config RESUBMITTED_SYSTEM_TRANSACTIONS_CONFIG = new SpeedometerMetric.Config("platform", "resubmittedSystemTransactions").withUnit("hz").withDescription("number of system transactions that have been resubmitted due to the host event becoming stale");
    private final SpeedometerMetric resubmittedSystemTransactions;
    private static final SpeedometerMetric.Config ABANDONED_SYSTEM_TRANSACTIONS_CONFIG = new SpeedometerMetric.Config("platform", "abandonedSystemTransactions").withUnit("hz").withDescription("number of system transactions that have been abandoned after the host event became stale");
    private final SpeedometerMetric abandonedSystemTransactions;

    public TransactionResubmitterMetrics(@NonNull PlatformContext platformContext) {
        this.resubmittedSystemTransactions = (SpeedometerMetric)platformContext.getMetrics().getOrCreate((MetricConfig)RESUBMITTED_SYSTEM_TRANSACTIONS_CONFIG);
        this.abandonedSystemTransactions = (SpeedometerMetric)platformContext.getMetrics().getOrCreate((MetricConfig)ABANDONED_SYSTEM_TRANSACTIONS_CONFIG);
    }

    public void reportResubmittedSystemTransaction() {
        this.resubmittedSystemTransactions.cycle();
    }

    public void reportAbandonedSystemTransaction() {
        this.abandonedSystemTransactions.cycle();
    }
}

