/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class TransactionHash
extends PartialMerkleLeaf
implements MerkleLeaf {
    private static final long CLASS_ID = 333217769738192271L;
    private static final int MAX_HASH_LENGTH = 512;
    private byte[] hash;

    public TransactionHash() {
    }

    private TransactionHash(byte[] hash) {
        this.hash = hash;
    }

    private TransactionHash(TransactionHash transactionHash) {
        super((PartialMerkleLeaf)transactionHash);
        this.hash = Arrays.copyOf(transactionHash.hash, transactionHash.hash.length);
    }

    public TransactionHash copy() {
        this.throwIfImmutable();
        return new TransactionHash(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.hash);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.hash = in.readByteArray(512);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionHash)) {
            return false;
        }
        TransactionHash that = (TransactionHash)((Object)o);
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    static TransactionHash generateRandom(Random random) {
        byte[] hash = new byte[48];
        random.nextBytes(hash);
        return new TransactionHash(hash);
    }

    public long getClassId() {
        return 333217769738192271L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

