/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Supplier;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.pool.TransactionPoolNexus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.model.status.PlatformStatus;

public class PlatformStatusRule
implements EventCreationRule {
    private final Supplier<PlatformStatus> platformStatusSupplier;
    private final TransactionPoolNexus transactionPoolNexus;

    public PlatformStatusRule(@NonNull Supplier<PlatformStatus> platformStatusSupplier, @NonNull TransactionPoolNexus transactionPoolNexus) {
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.transactionPoolNexus = Objects.requireNonNull(transactionPoolNexus);
    }

    @Override
    public boolean isEventCreationPermitted() {
        PlatformStatus currentStatus = this.platformStatusSupplier.get();
        if (currentStatus == PlatformStatus.FREEZING) {
            return this.transactionPoolNexus.hasBufferedSignatureTransactions();
        }
        return currentStatus == PlatformStatus.ACTIVE || currentStatus == PlatformStatus.CHECKING;
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.PLATFORM_STATUS;
    }
}

