/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.JoinDescription;
import org.assertj.core.util.Lists;

@Beta
public class MappedCondition<FROM, TO>
extends Condition<FROM> {
    private Condition<TO> condition;
    private Function<FROM, TO> mapping;
    private String mappingDescription;

    public static <FROM, TO> MappedCondition<FROM, TO> mappedCondition(Function<FROM, TO> mapping, Condition<TO> condition, String mappingDescription, Object ... args) {
        Objects.requireNonNull(mappingDescription, "The given mappingDescription should not be null");
        return new MappedCondition<FROM, TO>(mapping, condition, String.format(mappingDescription, args));
    }

    public static <FROM, TO> MappedCondition<FROM, TO> mappedCondition(Function<FROM, TO> mapping, Condition<TO> condition) {
        return MappedCondition.mappedCondition(mapping, condition, "", new Object[0]);
    }

    private MappedCondition(Function<FROM, TO> mapping, Condition<TO> condition, String mappingDescription) {
        Objects.requireNonNull(condition, "The given condition should not be null");
        Objects.requireNonNull(mapping, "The given mapping function should not be null");
        this.mapping = mapping;
        this.mappingDescription = mappingDescription;
        this.condition = condition;
    }

    @Override
    public boolean matches(FROM value) {
        TO mappedObject = this.mapping.apply(value);
        String desc = this.buildMappingDescription(value, mappedObject);
        this.describedAs(desc, new Object[0]);
        return this.condition.matches(mappedObject);
    }

    protected String buildMappingDescription(FROM from, TO to) {
        return this.buildMappingDescription(from, to, true);
    }

    private String buildMappingDescription(FROM from, TO to, boolean withNested) {
        StringBuilder sb = new StringBuilder("mapped");
        if (!this.mappingDescription.isEmpty()) {
            sb.append(String.format("%n   using: %s", this.mappingDescription));
        }
        if (from == null) {
            sb.append(String.format("%n   from: %s%n", from));
        } else {
            sb.append(String.format("%n   from: <%s> %s%n", MappedCondition.className(from), from));
        }
        if (to == null) {
            sb.append(String.format("   to:   %s%n", to));
        } else {
            sb.append(String.format("   to:   <%s> %s%n", MappedCondition.className(to), to));
        }
        sb.append("   then checked:");
        if (withNested) {
            sb.append(String.format("%n      %-10s", this.condition));
        }
        return sb.toString();
    }

    @Override
    public Description conditionDescriptionWithStatus(FROM actual) {
        TO mappedObject = this.mapping.apply(actual);
        Description descriptionsWithStatus = this.condition.conditionDescriptionWithStatus(mappedObject);
        Condition.Status status = this.status(actual);
        String descriptionStart = String.format("%s %s", new Object[]{status, this.buildMappingDescription(actual, mappedObject, false)});
        return new JoinDescription(descriptionStart, "", Lists.list(descriptionsWithStatus));
    }

    private static String className(Object object) {
        return object.getClass().getSimpleName();
    }
}

