/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.SplittableRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.test.fixtures.EcdsaUtils;

public class EcdsaSignedTxnPool {
    private static final int PUBLIC_KEY_LEN = 64;
    int poolSize;
    int transactionSize;
    boolean algorithmAvailable;
    AtomicInteger readPosition;
    SplittableRandom random = new SplittableRandom();
    ArrayList<SignedTxn> signedTxns;
    private KeyPair activeKp;

    public EcdsaSignedTxnPool(int poolSize, int transactionSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize");
        }
        if (transactionSize < 1) {
            throw new IllegalArgumentException("transactionSize");
        }
        this.poolSize = poolSize;
        this.transactionSize = transactionSize;
        this.signedTxns = new ArrayList(poolSize);
        this.readPosition = new AtomicInteger(0);
        this.algorithmAvailable = false;
        this.init();
    }

    public TransactionSignature next() {
        int nextIdx = this.readPosition.getAndIncrement();
        if (nextIdx >= this.signedTxns.size()) {
            nextIdx = 0;
            this.readPosition.set(1);
        }
        SignedTxn signedTxn = this.signedTxns.get(nextIdx);
        byte[] content = signedTxn.txn;
        return new TransactionSignature(Bytes.wrap((byte[])content, (int)0, (int)32), Bytes.wrap((byte[])content, (int)32, (int)64), Bytes.wrap((byte[])content, (int)96, (int)signedTxn.sigLen), SignatureType.ECDSA_SECP256K1);
    }

    void init() {
        this.generateActiveKeyPair();
        byte[] activePubKey = EcdsaUtils.asRawEcdsaSecp256k1Key((ECPublicKey)this.activeKp.getPublic());
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("KECCAK-256");
            for (int i = 0; i < this.poolSize; ++i) {
                byte[] rawMsg = new byte[this.transactionSize];
                this.random.nextBytes(rawMsg);
                byte[] msg = messageDigest.digest(rawMsg);
                byte[] sig = EcdsaUtils.signDigestWithEcdsaSecp256k1(this.activeKp.getPrivate(), msg);
                byte[] buffer = new byte[this.transactionSize + sig.length + activePubKey.length];
                System.arraycopy(msg, 0, buffer, 0, msg.length);
                System.arraycopy(activePubKey, 0, buffer, msg.length, activePubKey.length);
                System.arraycopy(sig, 0, buffer, msg.length + activePubKey.length, sig.length);
                SignedTxn signedTxn = new SignedTxn(sig.length, buffer);
                this.signedTxns.add(signedTxn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    void generateActiveKeyPair() {
        try {
            this.activeKp = EcdsaUtils.genEcdsaSecp256k1KeyPair();
        }
        catch (Exception fatal) {
            throw new IllegalStateException("Tests cannot be trusted without working key-pair generation", fatal);
        }
    }

    private static class SignedTxn {
        private final int sigLen;
        private final byte[] txn;

        public SignedTxn(int sigLen, byte[] txn) {
            this.sigLen = sigLen;
            this.txn = txn;
        }
    }
}

