/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkPeerIdentifier {
    private static final Logger logger = LogManager.getLogger(NetworkPeerIdentifier.class);
    private final RateLimitedLogger noPeerFoundLogger;
    private final Map<X500Principal, PeerInfo> x501PrincipalsAndPeers;

    public NetworkPeerIdentifier(@NonNull PlatformContext platformContext, @NonNull List<PeerInfo> peers) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(peers);
        this.noPeerFoundLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(5L));
        this.x501PrincipalsAndPeers = peers.stream().collect(Collectors.toMap(peer -> peer.signingCertificate().getSubjectX500Principal(), Function.identity()));
    }

    @Nullable
    public PeerInfo identifyTlsPeer(@NonNull Certificate[] certs) {
        Objects.requireNonNull(certs);
        if (certs.length == 0) {
            return null;
        }
        X509Certificate agreementCert = (X509Certificate)certs[0];
        PeerInfo matchedPeer = this.x501PrincipalsAndPeers.get(agreementCert.getIssuerX500Principal());
        if (matchedPeer == null) {
            this.noPeerFoundLogger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "Unable to identify peer with the presented certificate {}.", new Object[]{agreementCert});
        }
        return matchedPeer;
    }
}

