/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.hiero.base.Clearable;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.set.SequenceSet;
import org.hiero.consensus.model.sequence.set.StandardSequenceSet;

public class ConsensusOutput
implements Clearable {
    private final LinkedList<ConsensusRound> consensusRounds;
    private final LinkedList<PlatformEvent> addedEvents = new LinkedList();
    private final LinkedList<PlatformEvent> staleEvents;
    private final SequenceSet<PlatformEvent> nonAncientEvents;
    private final SequenceSet<EventDescriptorWrapper> nonAncientConsensusEvents;
    private long latestRound;
    private EventWindow eventWindow;

    public ConsensusOutput() {
        this.consensusRounds = new LinkedList();
        this.staleEvents = new LinkedList();
        this.nonAncientEvents = new StandardSequenceSet(0L, 1024, true, PlatformEvent::getBirthRound);
        this.nonAncientConsensusEvents = new StandardSequenceSet(0L, 1024, true, EventDescriptorWrapper::birthRound);
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }

    public void eventAdded(@NonNull PlatformEvent event) {
        this.addedEvents.add(event);
        this.nonAncientEvents.add((Object)event);
    }

    public void consensusRound(@NonNull ConsensusRound consensusRound) {
        this.consensusRounds.add(consensusRound);
        for (PlatformEvent consensusEvent : consensusRound.getConsensusEvents()) {
            this.nonAncientConsensusEvents.add((Object)consensusEvent.getDescriptor());
        }
        long ancientThreshold = consensusRound.getEventWindow().ancientThreshold();
        this.nonAncientEvents.shiftWindow(ancientThreshold, e -> {
            if (!this.nonAncientConsensusEvents.contains((Object)e.getDescriptor())) {
                this.staleEvents.add((PlatformEvent)e);
            }
        });
        this.nonAncientConsensusEvents.shiftWindow(ancientThreshold);
        this.eventWindow = consensusRound.getEventWindow();
    }

    @NonNull
    public LinkedList<PlatformEvent> getStaleEvents() {
        return this.staleEvents;
    }

    @NonNull
    public LinkedList<ConsensusRound> getConsensusRounds() {
        return this.consensusRounds;
    }

    @NonNull
    public LinkedList<PlatformEvent> getAddedEvents() {
        return this.addedEvents;
    }

    @NonNull
    public List<PlatformEvent> sortedAddedEvents() {
        ArrayList<PlatformEvent> sortedEvents = new ArrayList<PlatformEvent>(this.addedEvents);
        sortedEvents.sort(Comparator.comparingLong(PlatformEvent::getBirthRound).thenComparingLong(e -> e.getCreatorId().id()).thenComparing(PlatformEvent::getHash));
        return sortedEvents;
    }

    public long getLatestRound() {
        return this.latestRound;
    }

    @NonNull
    public EventWindow getEventWindow() {
        return this.eventWindow;
    }

    public void clear() {
        this.addedEvents.clear();
        this.consensusRounds.clear();
        this.staleEvents.clear();
        this.nonAncientEvents.clear();
        this.nonAncientConsensusEvents.clear();
        this.latestRound = 0L;
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }
}

