/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.demo.platform.nft.Nft;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.demo.platform.nft.NftLedger;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReferenceNftLedger {
    private final Map<NftId, Nft> tokenMap = new HashMap<NftId, Nft>();
    private final Map<MapKey, Set<NftId>> ownershipMap = new HashMap<MapKey, Set<NftId>>();
    private double fractionToTrack;
    private int fractionToTrackThreshold;
    private static final long FRACTION_TO_TRACK_MULTIPLICAND = 100003L;
    private static final int FRACTION_TO_TRACK_MODULUS = 10007;
    private static final double DEFAULT_FRACTION_TO_TRACK = 0.0;

    public ReferenceNftLedger() {
        this(0.0);
    }

    public ReferenceNftLedger(double fractionToTrack) {
        this.setFractionToTrack(null, fractionToTrack);
    }

    private ReferenceNftLedger(ReferenceNftLedger that) {
        this(that.fractionToTrack);
        for (NftId nftId : that.tokenMap.keySet()) {
            this.tokenMap.put(nftId, that.tokenMap.get(nftId).copy());
        }
        for (MapKey mapKey : that.ownershipMap.keySet()) {
            HashSet<NftId> setCopy = new HashSet<NftId>();
            for (NftId nftId : that.ownershipMap.get(mapKey)) {
                setCopy.add(nftId);
            }
            this.ownershipMap.put(mapKey.copy(), setCopy);
        }
    }

    public void setFractionToTrack(NftLedger fullLedger, double fractionToTrack) {
        if (fractionToTrack == this.fractionToTrack) {
            return;
        }
        this.fractionToTrack = fractionToTrack;
        if (fractionToTrack > 1.0) {
            throw new IllegalArgumentException("fraction must not exceed 1.0");
        }
        if (fractionToTrack < 0.0) {
            throw new IllegalArgumentException("minimum fraction to track is 0.0");
        }
        this.fractionToTrackThreshold = (int)(fractionToTrack * 10007.0);
        this.reload(fullLedger);
    }

    public void reload(NftLedger fullLedger) {
        this.clear();
        if (fullLedger == null || this.fractionToTrack == 0.0) {
            return;
        }
        for (NftId nftId : fullLedger.getTokenIdToToken().keySet()) {
            if (!this.isTokenTracked(nftId)) continue;
            Nft nftCopy = ((Nft)fullLedger.getTokenIdToToken().get((Object)nftId)).deepCopy();
            MapKey mapKeyCopy = nftCopy.getMapKey().copy();
            this.mintToken(mapKeyCopy, nftId, nftCopy);
        }
    }

    public void clear() {
        this.tokenMap.clear();
        this.ownershipMap.clear();
    }

    public Map<NftId, Nft> getTokenMap() {
        return this.tokenMap;
    }

    public Map<MapKey, Set<NftId>> getOwnershipMap() {
        return this.ownershipMap;
    }

    public boolean isTokenTracked(NftId nftId) {
        return (long)Math.abs(nftId.hashCode()) * 100003L % 10007L < (long)this.fractionToTrackThreshold;
    }

    public double getFractionToTrack() {
        return this.fractionToTrack;
    }

    public void mintToken(MapKey key, NftId nftId, Nft token) {
        if (!this.isTokenTracked(nftId)) {
            return;
        }
        if (this.tokenMap.containsKey(nftId)) {
            return;
        }
        this.tokenMap.put(nftId, token);
        if (!this.ownershipMap.containsKey(key)) {
            this.ownershipMap.put(key, new HashSet());
        }
        this.ownershipMap.get(key).add(new NftId(nftId.getShardNum(), nftId.getRealmNum(), nftId.getTokenNum()));
    }

    public void burnToken(NftId nftId) {
        if (!this.isTokenTracked(nftId)) {
            return;
        }
        Nft token = this.tokenMap.remove(nftId);
        if (token == null) {
            return;
        }
        MapKey owner = token.getMapKey();
        Set<NftId> tokensOwnedByOwner = this.ownershipMap.get(owner);
        tokensOwnedByOwner.remove(nftId);
        if (tokensOwnedByOwner.isEmpty()) {
            this.ownershipMap.remove(owner);
        }
    }

    public void transferToken(NftId nftId, MapKey toKey) {
        if (!this.isTokenTracked(nftId)) {
            return;
        }
        Nft token = this.tokenMap.get(nftId);
        if (token == null) {
            return;
        }
        this.burnToken(nftId);
        token.setMapKey(new MapKey(toKey.getShardId(), toKey.getRealmId(), toKey.getAccountId()));
        this.mintToken(toKey, nftId, token);
    }

    public ReferenceNftLedger copy() {
        return new ReferenceNftLedger(this);
    }

    public void assertValidity(NftLedger ledger) {
        for (NftId tokenId : this.tokenMap.keySet()) {
            if (!ledger.getTokenIdToToken().containsKey((Object)tokenId)) {
                throw new AssertionError((Object)("Token with ID " + String.valueOf(tokenId) + " is in the expected ledger but not the actual ledger"));
            }
            if (!this.tokenMap.get(tokenId).equals(ledger.getTokenIdToToken().get((Object)tokenId))) {
                throw new AssertionError((Object)("Token " + String.valueOf((Object)this.tokenMap.get(tokenId)) + " in the expected ledger does not match token " + String.valueOf(ledger.getTokenIdToToken().get((Object)tokenId)) + " in the actual ledger"));
            }
        }
        for (MapKey ownerId : this.ownershipMap.keySet()) {
            List ownedTokensList = ledger.getNftAccounts().getList((Object)ownerId);
            if (ownedTokensList == null) {
                throw new AssertionError((Object)("Account " + String.valueOf(ownerId) + " owns tokens in the expected ledger but not in the actual ledger"));
            }
            HashSet ownedTokensSet = new HashSet(ownedTokensList);
            for (NftId nftId : this.ownershipMap.get(ownerId)) {
                if (!ownedTokensSet.contains(nftId)) {
                    throw new AssertionError((Object)("Token " + String.valueOf(nftId) + " is owned by " + String.valueOf(ownerId) + " in the expected ledger but not in the actual ledger"));
                }
            }
        }
    }
}

