/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.schema.ThrottleGroupSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ThrottleGroupJsonCodec
implements JsonCodec<ThrottleGroup> {
    @NonNull
    public ThrottleGroup parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            List<HederaFunctionality> temp_operations = Collections.emptyList();
            long temp_milliOpsPerSec = 0L;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "operations": {
                        temp_operations = kvPair.value().arr().value().stream().map(v -> HederaFunctionality.fromString(v.STRING().getText())).toList();
                        continue block10;
                    }
                    case "milliOpsPerSec": {
                        temp_milliOpsPerSec = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ThrottleGroup(temp_operations, temp_milliOpsPerSec);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ThrottleGroup data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (!data.operations().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"operations", (FieldDefinition)ThrottleGroupSchema.OPERATIONS, data.operations()));
        }
        if (data.milliOpsPerSec() != 0L) {
            fieldLines.add(JsonTools.field((String)"milliOpsPerSec", (long)data.milliOpsPerSec()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

