/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.extensions.PhaseTimer;
import com.swirlds.common.metrics.extensions.PhaseTimerBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.hiero.consensus.event.FutureEventBuffer;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.EventCreator;
import org.hiero.consensus.event.creator.impl.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.pool.TransactionPoolNexus;
import org.hiero.consensus.event.creator.impl.rules.AggregateEventCreationRules;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.event.creator.impl.rules.MaximumRateRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformHealthRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformStatusRule;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultEventCreationManager
implements EventCreationManager {
    private final EventCreator creator;
    private final EventCreationRule eventCreationRules;
    private final PhaseTimer<EventCreationStatus> phase;
    private PlatformStatus platformStatus;
    private Duration unhealthyDuration = Duration.ZERO;
    private final FutureEventBuffer futureEventBuffer;

    public DefaultEventCreationManager(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull TransactionPoolNexus transactionPoolNexus, @NonNull EventCreator creator) {
        this.creator = Objects.requireNonNull(creator);
        EventCreationConfig config = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        ArrayList<EventCreationRule> rules = new ArrayList<EventCreationRule>();
        rules.add(new MaximumRateRule(configuration, time));
        rules.add(new PlatformStatusRule(this::getPlatformStatus, transactionPoolNexus));
        rules.add(new PlatformHealthRule(config.maximumPermissibleUnhealthyDuration(), this::getUnhealthyDuration));
        this.eventCreationRules = AggregateEventCreationRules.of(rules);
        this.futureEventBuffer = new FutureEventBuffer(metrics, FutureEventBufferingOption.EVENT_BIRTH_ROUND, "eventCreator");
        this.phase = new PhaseTimerBuilder(metrics, time, "platform", EventCreationStatus.class).enableFractionalMetrics().setInitialPhase((Enum)EventCreationStatus.IDLE).setMetricsNamePrefix("eventCreation").build();
    }

    @Override
    @Nullable
    public PlatformEvent maybeCreateEvent() {
        if (!this.eventCreationRules.isEventCreationPermitted()) {
            this.phase.activatePhase((Enum)this.eventCreationRules.getEventCreationStatus());
            return null;
        }
        this.phase.activatePhase((Enum)EventCreationStatus.ATTEMPTING_CREATION);
        PlatformEvent newEvent = this.creator.maybeCreateEvent();
        if (newEvent == null) {
            this.phase.activatePhase((Enum)EventCreationStatus.NO_ELIGIBLE_PARENTS);
        } else {
            this.eventCreationRules.eventWasCreated();
            this.phase.activatePhase((Enum)EventCreationStatus.RATE_LIMITED);
        }
        return newEvent;
    }

    @Override
    public void registerEvent(@NonNull PlatformEvent event) {
        PlatformEvent nonFutureEvent = this.futureEventBuffer.addEvent(event);
        if (nonFutureEvent != null) {
            this.creator.registerEvent(event);
        }
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.creator.setEventWindow(eventWindow);
        this.futureEventBuffer.updateEventWindow(eventWindow).forEach(this.creator::registerEvent);
    }

    @Override
    public void clear() {
        this.creator.clear();
        this.phase.activatePhase((Enum)EventCreationStatus.IDLE);
        this.futureEventBuffer.clear();
        EventWindow eventWindow = EventWindow.getGenesisEventWindow();
        this.futureEventBuffer.updateEventWindow(eventWindow);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatus = Objects.requireNonNull(platformStatus);
    }

    @Override
    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.unhealthyDuration = Objects.requireNonNull(duration);
    }

    @NonNull
    private PlatformStatus getPlatformStatus() {
        return this.platformStatus;
    }

    private Duration getUnhealthyDuration() {
        return this.unhealthyDuration;
    }
}

