/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.SnapshotableMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public abstract class AbstractMetric
implements SnapshotableMetric {
    private final String category;
    private final String name;
    private final String description;
    private final String unit;
    private final String format;

    protected AbstractMetric(@NonNull MetricConfig<?, ?> config) {
        Objects.requireNonNull(config, "config must not be null");
        this.category = config.getCategory();
        this.name = config.getName();
        this.description = config.getDescription();
        this.unit = config.getUnit();
        this.format = config.getFormat();
    }

    @NonNull
    public String getCategory() {
        return this.category;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getUnit() {
        return this.unit;
    }

    @NonNull
    public String getFormat() {
        return this.format;
    }

    public void reset() {
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractMetric metric = (AbstractMetric)other;
        return this.category.equals(metric.category) && this.name.equals(metric.name);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.name);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("category", (Object)this.category).append("name", (Object)this.name).append("description", (Object)this.description).append("unit", (Object)this.unit).append("format", (Object)this.format).append("dataType", (Object)this.getDataType()).toString();
    }
}

