/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.permits;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.permits.SyncGuard;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class LruSyncGuard
implements SyncGuard {
    private static final Logger logger = LogManager.getLogger(LruSyncGuard.class);
    private final int maxConcurrentSyncs;
    private final int minimalRoundRobinSize;
    private final List<NodeId> recentSyncs = new ArrayList<NodeId>();
    private final Set<NodeId> syncsInProgress = new HashSet<NodeId>();

    public LruSyncGuard(int maxConcurrentSyncs, int minimalRoundRobinSize) {
        this.maxConcurrentSyncs = maxConcurrentSyncs;
        this.minimalRoundRobinSize = minimalRoundRobinSize;
    }

    @Override
    public synchronized boolean isSyncAllowed(@NonNull NodeId nodeId) {
        if (this.syncsInProgress.size() >= this.maxConcurrentSyncs) {
            return false;
        }
        this.checkNotInProgress(nodeId);
        int index = this.recentSyncs.indexOf(nodeId);
        if (index < 0) {
            this.syncsInProgress.add(nodeId);
            return true;
        }
        if (this.recentSyncs.size() < this.minimalRoundRobinSize) {
            return false;
        }
        if (index < this.maxConcurrentSyncs) {
            this.syncsInProgress.add(nodeId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void onForcedSync(@NonNull NodeId nodeId) {
        this.checkNotInProgress(nodeId);
        this.syncsInProgress.add(nodeId);
    }

    private void checkNotInProgress(NodeId nodeId) {
        if (this.syncsInProgress.contains(nodeId)) {
            logger.error(LogMarker.SYNC_INFO.getMarker(), "Node " + String.valueOf(nodeId) + " already has a sync selector permit.");
            throw new IllegalStateException("Node " + String.valueOf(nodeId) + " already has a sync selector permit.");
        }
    }

    @Override
    public synchronized void onSyncCompleted(@NonNull NodeId nodeId) {
        this.syncsInProgress.remove(nodeId);
        this.recentSyncs.remove(nodeId);
        this.recentSyncs.add(nodeId);
    }

    @Override
    public synchronized void addRemovePeers(@NonNull List<PeerInfo> added, @NonNull List<PeerInfo> removed) {
        removed.forEach(peerInfo -> {
            this.recentSyncs.remove(peerInfo.nodeId());
            if (this.syncsInProgress.contains(peerInfo.nodeId())) {
                logger.error(LogMarker.SYNC_INFO.getMarker(), "Connection against {} still in sync, while getting removed from syn permits!", (Object)peerInfo.nodeId());
            }
        });
    }
}

