/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map.internal;

import com.google.protobuf.InvalidProtocolBufferException;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.test.fixtures.set.RandomAccessHashSet;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.FCMFamily;
import com.swirlds.demo.merkle.map.FCMTransactionUtils;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransactionWrapper;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import java.io.IOException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.CommonUtils;

public final class ExpectedFCMFamilyImpl
implements ExpectedFCMFamily {
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private static final Marker EXPIRATION_MARKER = MarkerManager.getMarker((String)"EXPIRATION");
    private static final Marker PERFORM_ON_CREATE_DELETE = MarkerManager.getMarker((String)"PERFORM_ON_CREATE_DELETE");
    private static final Marker DEMO_TRANSACTION_INFO = MarkerManager.getMarker((String)"DEMO_TRANSACTION_INFO");
    private static final Marker DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Logger logger = LogManager.getLogger(ExpectedFCMFamily.class);
    private Map<MapKey, ExpectedValue> expectedMap;
    private AtomicLong largestInExpectedMap = new AtomicLong(0L);
    private List<MapKey> accountList;
    private List<MapKey> fcqList;
    private List<MapKey> virtualMerkleAccountList;
    private int cryptoDeleteIdx;
    private int fcqDeleteIdx = 0;
    private int virtualMerkleAccountDeleteIdx;
    private int cryptoCounter;
    private int fcqCounter = 0;
    private int virtualMerkleAccountCounter;
    private List<MapKey> accountSelfEntitiesList;
    private List<MapKey> fcqSelfEntitiesList;
    private List<MapKey> virtualMerkleAccountSelfEntitiesList;
    private long nodeId;
    private FCMConfig fcmConfig;
    private int weightedNodeNum;
    private static final int DEFAULT_LIST_CAPACITY = 1000;
    private static final int ENTITY_TYPES_NUM = 4;
    private static final Random RANDOM = new SecureRandom();
    private final transient RandomAccessHashSet<NftId> availableNfts = new RandomAccessHashSet();

    public ExpectedFCMFamilyImpl() {
        this.initExpectedMapAndLists(false);
    }

    @Override
    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public void setFcmConfig(FCMConfig fcmConfig) {
        this.fcmConfig = fcmConfig;
    }

    @Override
    public void setWeightedNodeNum(int weightedNodeNum) {
        this.weightedNodeNum = weightedNodeNum;
    }

    private void initExpectedMapAndLists(boolean isRestart) {
        if (isRestart) {
            logger.info(DEMO_INFO, "Initialize ExpectedMap and Lists before rebuilding at Restart");
        }
        this.initExpectedMap(isRestart);
        this.initEntityListCapacity(EntityType.Crypto, isRestart);
        this.initEntityListCapacity(EntityType.FCQ, isRestart);
        this.initEntityListCapacity(EntityType.VIRTUAL_MERKLE_ACCOUNT, isRestart);
    }

    private int getEntityListInitCapacity(EntityType entityType) {
        return this.fcmConfig == null ? 1000 : this.fcmConfig.getExpectedEntityAmountForTypePerNode(entityType) * this.weightedNodeNum;
    }

    private int getExpectedMapInitCapacity() {
        return this.fcmConfig == null ? 4000 : this.fcmConfig.getExpectedEntityAmountTotalPerNode() * this.weightedNodeNum;
    }

    private int getVirtualMerkleAccountCounter() {
        return this.virtualMerkleAccountCounter;
    }

    private int getCryptoCounter() {
        return this.cryptoCounter;
    }

    private int getFcqCounter() {
        return this.fcqCounter;
    }

    public void setCryptoCounter(int cryptoCounter) {
        this.cryptoCounter = cryptoCounter;
    }

    public void setFcqCounter(int fcqCounter) {
        this.fcqCounter = fcqCounter;
    }

    private int getCounter(EntityType type) {
        switch (type) {
            case FCQ: {
                return this.getFcqCounter();
            }
            case Crypto: {
                return this.getCryptoCounter();
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                return this.getVirtualMerkleAccountCounter();
            }
        }
        throw new IllegalArgumentException("Unrecognized entity type:" + String.valueOf(type));
    }

    private boolean waitIfExpectedMapEmpty(EntityType entityType) {
        return this.getCounter(entityType) == 0 && this.getExpectedMap() != null && this.getExpectedMap().size() == 0;
    }

    @Override
    public void waitWhileExpectedMapEmpty(EntityType entityType, PAYLOAD_TYPE type) {
        while (this.waitIfExpectedMapEmpty(entityType)) {
            try {
                Thread.sleep(500L);
                logger.info(MARKER, "{} is zero, cannot generate transaction of type {}, waiting...", (Object)entityType, (Object)type.name());
            }
            catch (InterruptedException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "", (Throwable)e);
            }
        }
    }

    @Override
    public Map<MapKey, ExpectedValue> getExpectedMap() {
        return this.expectedMap;
    }

    @Override
    public long getNextIdToCreate() {
        return Math.max((long)this.expectedMap.size(), this.largestInExpectedMap.get() + 1L);
    }

    @Override
    public MapKey getMapKeyForFCMTx(TransactionType txType, EntityType entityType, boolean performOnDeleted, boolean operateEntitiesOfSameNode, int restrictedCount) {
        MapKey mapKey;
        List<MapKey> selfEntitiesList;
        List<MapKey> entityList;
        int deleteIdx = switch (entityType) {
            case EntityType.Crypto -> {
                entityList = this.accountList;
                selfEntitiesList = this.accountSelfEntitiesList;
                yield this.cryptoDeleteIdx;
            }
            case EntityType.FCQ -> {
                entityList = this.fcqList;
                selfEntitiesList = this.fcqSelfEntitiesList;
                yield this.fcqDeleteIdx;
            }
            case EntityType.VIRTUAL_MERKLE_ACCOUNT -> {
                entityList = this.virtualMerkleAccountList;
                selfEntitiesList = this.virtualMerkleAccountSelfEntitiesList;
                yield this.virtualMerkleAccountDeleteIdx;
            }
            default -> throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
        };
        if (txType.equals((Object)TransactionType.Delete)) {
            mapKey = this.getMapKeyToDelete(deleteIdx, selfEntitiesList, entityType);
        } else if (performOnDeleted) {
            mapKey = this.getRandomMapKey(deleteIdx, entityList, selfEntitiesList, operateEntitiesOfSameNode, restrictedCount);
        } else {
            while (this.isRemovedEntity(mapKey = this.getRandomMapKey(deleteIdx, entityList, selfEntitiesList, operateEntitiesOfSameNode, restrictedCount))) {
            }
        }
        if (mapKey == null) {
            if (restrictedCount > 0) {
                logger.info(DEMO_TRANSACTION_INFO, String.format("getMapKeyForFCMTx :: Fail to choose MapKey when initializing %s %s account subset Transaction, because %sList in ExpectedMap is empty or all entities has been removed. deleteIdx: %s, entityList size: %s, selfEntitiesList size: %s, accountSubset: %s", txType, entityType, entityType, deleteIdx, entityList.size(), selfEntitiesList.size(), restrictedCount));
            } else {
                logger.info(DEMO_TRANSACTION_INFO, String.format("getMapKeyForFCMTx :: Fail to choose MapKey when initializing %s %s Transaction, because %sList in ExpectedMap is empty or all entities has been removed. deleteIdx: %s, entityList size: %s, selfEntitiesList size: %s", txType, entityType, entityType, deleteIdx, entityList.size(), selfEntitiesList.size()));
            }
        }
        return mapKey;
    }

    @Override
    public synchronized Optional<NftId> getAnyNftId() {
        if (this.availableNfts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((NftId)this.availableNfts.get(RANDOM));
    }

    @Override
    public boolean doesTokenWithIdExist(NftId id) {
        return this.availableNfts.contains((Object)id);
    }

    @Override
    public synchronized void addNftId(NftId nftId) {
        this.availableNfts.add((Object)nftId);
    }

    @Override
    public synchronized boolean removeNftid(NftId nftId) {
        return this.availableNfts.remove((Object)nftId);
    }

    private int nextStructuredRandomInt(int range, int restrictedCount) {
        if (restrictedCount < 2 || range <= restrictedCount) {
            return ThreadLocalRandom.current().nextInt(range);
        }
        double scalar = ((double)range - 1.0) / ((double)restrictedCount - 1.0);
        return (int)Math.floor((double)ThreadLocalRandom.current().nextInt(restrictedCount) * scalar);
    }

    private MapKey getRandomMapKey(int deleteIdx, List<MapKey> entityList, List<MapKey> selfEntitiesList, boolean operateEntitiesOfSameNode, int restrictedCount) {
        if (operateEntitiesOfSameNode) {
            if (selfEntitiesList.isEmpty() || deleteIdx >= selfEntitiesList.size()) {
                return null;
            }
            return selfEntitiesList.get(this.nextStructuredRandomInt(selfEntitiesList.size(), restrictedCount));
        }
        if (entityList.isEmpty() || deleteIdx >= selfEntitiesList.size()) {
            return null;
        }
        return entityList.get(this.nextStructuredRandomInt(entityList.size(), restrictedCount));
    }

    private MapKey getMapKeyToDelete(int deleteIdx, List<MapKey> entityList, EntityType entityType) {
        MapKey key = null;
        for (int i = deleteIdx; i < entityList.size(); ++i) {
            key = entityList.get(i);
            if (this.isRemovedEntity(key)) continue;
            this.updateDeleteIndex(entityType, i + 1);
            return key;
        }
        this.updateDeleteIndex(entityType, entityList.size());
        return key;
    }

    private void updateDeleteIndex(EntityType entityType, int index) {
        switch (entityType) {
            case Crypto: {
                this.cryptoDeleteIdx = index;
                break;
            }
            case FCQ: {
                this.fcqDeleteIdx = index;
                break;
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                this.virtualMerkleAccountDeleteIdx = index;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
            }
        }
    }

    @Override
    public boolean shouldHandleForKeys(List<MapKey> mapKeys, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        for (MapKey mapKey : mapKeys) {
            if (this.shouldHandle(mapKey, transactionType, payloadCfgSimple, entityType, epochMillis, originId)) continue;
            return false;
        }
        return true;
    }

    boolean shouldHandle(MapKey mapKey, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        ExpectedValue expectedValue = this.expectedMap.get(mapKey);
        if (expectedValue == null) {
            return this.checkPerformOnNonExistingEntities(mapKey, transactionType, payloadCfgSimple, entityType, epochMillis, originId);
        }
        if (expectedValue.getLatestHandledStatus() == null) {
            return this.checkPerformOnNonExistingEntities(mapKey, transactionType, payloadCfgSimple, entityType, epochMillis, originId);
        }
        if (expectedValue.isHandleRejected()) {
            logger.info(DEMO_TRANSACTION_INFO, "Allowed PerformOnDeleted, MapKey: {}, TransactionType: {}", (Object)mapKey, (Object)transactionType);
            return false;
        }
        if (this.creatingOnExistingEntities(expectedValue, mapKey, transactionType, payloadCfgSimple)) {
            return false;
        }
        if (this.entityTypeMismatch(mapKey, transactionType, entityType, epochMillis, originId)) {
            return false;
        }
        return !this.performingOnRemoved(mapKey, transactionType, payloadCfgSimple, entityType, epochMillis, originId);
    }

    private boolean checkPerformOnNonExistingEntities(MapKey mapKey, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        if (transactionType == TransactionType.Create) {
            return true;
        }
        if (payloadCfgSimple != null && payloadCfgSimple.isPerformOnNonExistingEntities()) {
            logger.info(DEMO_TRANSACTION_INFO, "Allowed PerformOnNonExistingEntities, MapKey: {}, TransactionType: {}", (Object)mapKey, (Object)transactionType);
            return false;
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), "Error PerformOnNonExistingEntities, MapKey: {}, TransactionType: {}", (Object)mapKey, (Object)transactionType);
        this.setLatestHandledStatusForKey(mapKey, entityType, null, TransactionState.HANDLE_REJECTED, transactionType, epochMillis, originId, true);
        return false;
    }

    private boolean creatingOnExistingEntities(ExpectedValue expectedValue, MapKey mapKey, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple) {
        if (transactionType == TransactionType.Create && expectedValue.getLatestHandledStatus() != null) {
            if (payloadCfgSimple != null && payloadCfgSimple.isCreateOnExistingEntities()) {
                logger.info(DEMO_TRANSACTION_INFO, "Allowed CreateOnExistingEntities, MapKey: {}, TransactionType: {}, EntityType: {}", (Object)mapKey, (Object)transactionType, (Object)expectedValue.getEntityType());
            } else {
                expectedValue.setErrored(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean insertMissingEntity(byte[] payload, ExpectedFCMFamily expectedFCMFamily, MapKey key, PayloadConfig payloadConfig) {
        TestTransaction trans = this.parseTransaction(payload, payloadConfig.isAppendSig());
        if (trans == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error while parsing transaction, so could not insert entity with MapKey {} to ExpectedMap", (Object)key);
            return false;
        }
        TransactionType transactionType = FCMTransactionUtils.getTransactionType(trans.getFcmTransaction());
        if (transactionType == TransactionType.TransferToken || transactionType == TransactionType.BurnToken) {
            return true;
        }
        List<MapKey> mapKeys = FCMTransactionUtils.getMapKeys(trans.getFcmTransaction());
        if (!mapKeys.contains(key)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "MapKeys extracted from FCMTransaction {} and MapKey provided to modifySubmitStatus {} doesn't match ", mapKeys, (Object)key);
            return false;
        }
        if (transactionType != TransactionType.Create) {
            if (!payloadConfig.isPerformOnNonExistingEntities()) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "performOnNonExistingEntities is not allowed and MapKey {} doesn't exist in ExpectedMap while modifyingSubmitStatus for transactionType {} ", (Object)key, (Object)transactionType);
            } else {
                logger.info(DEMO_TRANSACTION_INFO, "performOnNonExistingEntities is allowed and MapKey {} doesn't exist in ExpectedMap while modifyingSubmitStatus for transactionType {} ", (Object)key, (Object)transactionType);
            }
            return false;
        }
        long originNodeId = FCMTransactionUtils.getNodeId(trans.getFcmTransaction());
        EntityType entityType = FCMTransactionUtils.getEntityType(trans.getFcmTransaction());
        LifecycleStatus submitStatus = LifecycleStatus.builder().setTransactionType(transactionType).setTransactionState(TransactionState.INITIALIZED).setTimestamp(Instant.now().getEpochSecond()).setNodeId(originNodeId).build();
        expectedFCMFamily.getExpectedMap().put(key, new ExpectedValue(entityType, submitStatus));
        return true;
    }

    @Override
    public LifecycleStatus buildLifecycleStatusFromPayload(byte[] payload, PayloadConfig payloadConfig) {
        TestTransaction trans = this.parseTransaction(payload, payloadConfig.isAppendSig());
        long originNodeId = FCMTransactionUtils.getNodeId(trans.getFcmTransaction());
        TransactionType transactionType = FCMTransactionUtils.getTransactionType(trans.getFcmTransaction());
        return LifecycleStatus.builder().setTransactionType(transactionType).setTransactionState(TransactionState.INITIALIZED).setTimestamp(Instant.now().getEpochSecond()).setNodeId(originNodeId).build();
    }

    private TestTransaction parseTransaction(byte[] payload, boolean isAppendSig) {
        TestTransaction trans;
        byte[] payloadBytes;
        if (isAppendSig) {
            try {
                payloadBytes = TestTransactionWrapper.parseFrom(payload).getTestTransactionRawBytes().toByteArray();
            }
            catch (InvalidProtocolBufferException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Could not parsing TestTransactionWrapper with payload {}", (Object)CommonUtils.hex((byte[])payload), (Object)e);
                return null;
            }
        } else {
            payloadBytes = payload;
        }
        try {
            trans = TestTransaction.parseFrom(payloadBytes);
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Could not parsing TestTransaction with payload {}", (Object)CommonUtils.hex((byte[])payload), (Object)e);
            return null;
        }
        return trans;
    }

    private boolean entityTypeMismatch(MapKey mapKey, TransactionType transactionType, EntityType entityType, long epochMillis, long originId) {
        if (this.expectedMap.containsKey(mapKey) && !this.checkEntityType(mapKey, entityType)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Entity type mismatch, MapKey: {}, TransactionType: {}, originId: {}", (Object)mapKey, (Object)transactionType, (Object)originId);
            this.setLatestHandledStatusForKey(mapKey, entityType, null, TransactionState.HANDLE_ENTITY_TYPE_MISMATCH, transactionType, epochMillis, originId, true);
            return true;
        }
        return false;
    }

    private boolean performingOnRemoved(MapKey mapKey, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        if (this.entityHasBeenRemoved(mapKey)) {
            this.logDeleteInfo(mapKey, transactionType, payloadCfgSimple, entityType, epochMillis, originId);
            return true;
        }
        return false;
    }

    private void logDeleteInfo(MapKey mapKey, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        boolean isError;
        boolean bl = isError = payloadCfgSimple == null || !payloadCfgSimple.isPerformOnDeleted();
        if (isError) {
            logger.info(PERFORM_ON_CREATE_DELETE, "latestHandledStatus set to be HANDLE_REJECTED. ERROR PerformOnDeleted, MapKey: {}, TransactionType: {}, originId: {}", (Object)mapKey, (Object)transactionType, (Object)originId);
        }
        this.setLatestHandledStatusForKey(mapKey, entityType, null, TransactionState.HANDLE_REJECTED, transactionType, epochMillis, originId, isError);
    }

    @Override
    public void setLatestHandledStatusForKey(MapKey mapKey, EntityType entityType, MapValue mapValue, TransactionState state, TransactionType transactionType, long timestamp, long nodeId, boolean error) {
        try {
            Hash newHash = mapValue == null ? null : mapValue.calculateHash();
            ExpectedValue expectedValue = this.expectedMap.get(mapKey);
            boolean newEntity = false;
            if (expectedValue == null) {
                newEntity = true;
                expectedValue = new ExpectedValue(entityType, null);
                expectedValue.setUid(mapValue == null ? 0L : mapValue.getUid());
            }
            if (expectedValue.getUid() == 0L && mapValue != null) {
                expectedValue.setUid(mapValue.getUid());
            }
            if (newHash != null) {
                expectedValue.setHash(newHash);
                logger.trace(EXPIRATION_MARKER, "New Hash calculated after modifying latestHandledStatus {} for mapKey {}", (Object)newHash, (Object)mapKey);
            }
            expectedValue.setErrored(error);
            expectedValue.setHistoryHandledStatus(expectedValue.getLatestHandledStatus());
            expectedValue.setLatestHandledStatus(new LifecycleStatus(state, transactionType, timestamp, nodeId));
            if (newEntity) {
                this.addEntityToExpectedMap(mapKey, expectedValue);
            }
            if (state == TransactionState.HANDLED && (transactionType == TransactionType.Create || transactionType == TransactionType.Delete)) {
                this.updateEntityCounter(transactionType, entityType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean entityHasBeenRemoved(MapKey mapKey) {
        if (this.expectedMap == null || !this.expectedMap.containsKey(mapKey)) {
            return false;
        }
        LifecycleStatus latestHandledStatus = this.expectedMap.get(mapKey).getLatestHandledStatus();
        LifecycleStatus historyHandledStatus = this.expectedMap.get(mapKey).getHistoryHandledStatus();
        if (latestHandledStatus == null) {
            return false;
        }
        TransactionType latestHandledTxType = latestHandledStatus.getTransactionType();
        if (historyHandledStatus == null) {
            return latestHandledTxType == TransactionType.Delete || latestHandledTxType == TransactionType.Expire;
        }
        TransactionType historyHandledTxType = historyHandledStatus.getTransactionType();
        return latestHandledTxType == TransactionType.Delete || latestHandledTxType == TransactionType.Expire || historyHandledTxType == TransactionType.Delete || historyHandledTxType == TransactionType.Expire;
    }

    private boolean isRemovedEntity(MapKey mapKey) {
        if (mapKey == null || !this.expectedMap.containsKey(mapKey)) {
            return false;
        }
        if (this.entityHasBeenRemoved(mapKey)) {
            return true;
        }
        LifecycleStatus latestSubmitStatus = this.expectedMap.get(mapKey).getLatestSubmitStatus();
        return latestSubmitStatus != null && latestSubmitStatus.getTransactionType() == TransactionType.Delete;
    }

    boolean checkEntityType(MapKey key, EntityType entityType) {
        if (this.expectedMap == null || !this.expectedMap.containsKey(key) || entityType == EntityType.NFT) {
            return true;
        }
        return this.expectedMap.get(key).getEntityType().equals((Object)entityType);
    }

    @Override
    public void rebuildExpectedMap(FCMFamily fcmFamily, boolean isRestart, long timestamp) {
        if (fcmFamily == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "fail to rebuild ExpectedMap, fcmFamily is null");
            return;
        }
        if (this.expectedMap == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "fail to rebuild ExpectedMap, ExpectedMap is null");
            return;
        }
        HashMap<MapKey, ExpectedValue> expectedMapOld = new HashMap<MapKey, ExpectedValue>(this.expectedMap);
        this.clear();
        this.cryptoCounter = fcmFamily.getMap().size();
        this.fcqCounter = fcmFamily.getAccountFCQMap().size();
        this.initExpectedMapAndLists(isRestart);
        this.addEntitiesFromActualFCMs(fcmFamily, EntityType.Crypto, isRestart, timestamp, expectedMapOld);
        this.addEntitiesFromActualFCMs(fcmFamily, EntityType.FCQ, isRestart, timestamp, expectedMapOld);
    }

    private void addEntitiesFromActualFCMs(FCMFamily fcmFamily, EntityType entityType, boolean isRestart, long timestamp, Map<MapKey, ExpectedValue> expectedMapOld) {
        Map<MapKey, ? extends MerkleNode> actualMap = fcmFamily.getActualMap(entityType);
        if (actualMap == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "fail to rebuild ExpectedMap for {} Entity, actualMap is null", (Object)entityType);
            return;
        }
        logger.info(DEMO_TRANSACTION_INFO, "type: {}, actualMap size: {}", (Object)entityType, (Object)actualMap.size());
        List<MapKey> entityList = this.getEntityList(entityType);
        List<MapKey> selfEntities = this.getSelfEntitiesList(entityType);
        TransactionState transactionState = isRestart ? TransactionState.RESTART_ORIGIN : TransactionState.RECONNECT_ORIGIN;
        long nodeId = -1L;
        for (Map.Entry<MapKey, ? extends MerkleNode> entry : actualMap.entrySet()) {
            Hash hash = entry.getValue().getHash();
            LifecycleStatus latestHandledStatus = new LifecycleStatus(transactionState, TransactionType.Rebuild, timestamp, nodeId);
            long uid = ((MapValue)entry.getValue()).getUid();
            ExpectedValue expectedValue = new ExpectedValue(entityType, hash, false, null, latestHandledStatus, null, uid);
            ExpectedValue oldValue = expectedMapOld.get(entry.getKey());
            if (!isRestart && this.isEntityDeleted(oldValue)) {
                expectedValue = expectedValue.setLatestSubmitStatus(oldValue.getLatestSubmitStatus());
            }
            this.addEntityToExpectedMap(entry.getKey(), expectedValue);
        }
        if (!isRestart) {
            this.addEntitiesCreated(expectedMapOld);
        }
        this.logRebuildingMsg(entityType, actualMap.size(), entityList.size(), selfEntities.size());
    }

    boolean isEntityDeleted(ExpectedValue oldValue) {
        if (oldValue == null) {
            return false;
        }
        LifecycleStatus submitStatus = oldValue.getLatestSubmitStatus();
        return submitStatus != null && submitStatus.getTransactionType() != null && submitStatus.getTransactionType().equals((Object)TransactionType.Delete) && submitStatus.getTransactionState() != null && !submitStatus.getTransactionState().equals((Object)TransactionState.SUBMISSION_FAILED);
    }

    void addEntitiesCreated(Map<MapKey, ExpectedValue> expectedMapOld) {
        List<MapKey> createdEntities = expectedMapOld.keySet().stream().filter(e -> !this.expectedMap.containsKey(e) && this.isEntityCreated((ExpectedValue)expectedMapOld.get(e))).collect(Collectors.toList());
        createdEntities.forEach(e -> this.addEntityToExpectedMap((MapKey)e, (ExpectedValue)expectedMapOld.get(e)));
    }

    boolean isEntityCreated(ExpectedValue oldValue) {
        if (oldValue == null) {
            return false;
        }
        LifecycleStatus submitStatus = oldValue.getLatestSubmitStatus();
        LifecycleStatus handleStatus = oldValue.getLatestHandledStatus();
        return submitStatus != null && handleStatus == null && submitStatus.getTransactionType() != null && submitStatus.getTransactionType().equals((Object)TransactionType.Create) && submitStatus.getTransactionState() != null && !submitStatus.getTransactionState().equals((Object)TransactionState.SUBMISSION_FAILED);
    }

    @Override
    public void addEntityToExpectedMap(MapKey mapKey, ExpectedValue expectedValue) {
        EntityType entityType = expectedValue.getEntityType();
        List<MapKey> entityList = this.getEntityList(entityType);
        List<MapKey> selfEntities = this.getSelfEntitiesList(entityType);
        this.expectedMap.put(mapKey, expectedValue);
        entityList.add(mapKey);
        if (this.isSelfCreated(mapKey)) {
            selfEntities.add(mapKey);
        }
        if (mapKey.getAccountId() > this.largestInExpectedMap.get()) {
            this.largestInExpectedMap.set(mapKey.getAccountId());
        }
    }

    private boolean isSelfCreated(MapKey mapKey) {
        return mapKey.getShardId() == this.nodeId && mapKey.getRealmId() == this.nodeId;
    }

    List<MapKey> getEntityList(EntityType entityType) {
        switch (entityType) {
            case Crypto: {
                return this.accountList;
            }
            case FCQ: {
                return this.fcqList;
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                return this.virtualMerkleAccountList;
            }
        }
        throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
    }

    List<MapKey> getSelfEntitiesList(EntityType entityType) {
        switch (entityType) {
            case Crypto: {
                return this.accountSelfEntitiesList;
            }
            case FCQ: {
                return this.fcqSelfEntitiesList;
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                return this.virtualMerkleAccountSelfEntitiesList;
            }
        }
        throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
    }

    void logRebuildingMsg(EntityType entityType, int actualMapSize, int entityListSize, int selfEntitiesSize) {
        logger.info(DEMO_TRANSACTION_INFO, "Finish adding {}s to ExpectedMap, actual MerkleMap size: {}, ExpectedFCMFamily's {}EntityList size: {}, SelfEntitiesList size: {}, ExpectedMap's size: {}", (Object)entityType, (Object)actualMapSize, (Object)entityType, (Object)entityListSize, (Object)selfEntitiesSize, (Object)this.expectedMap.size());
    }

    void clear() {
        this.expectedMap.clear();
        this.accountList.clear();
        this.fcqList.clear();
        this.virtualMerkleAccountList.clear();
        this.accountSelfEntitiesList.clear();
        this.fcqSelfEntitiesList.clear();
        this.virtualMerkleAccountSelfEntitiesList.clear();
        this.cryptoDeleteIdx = 0;
        this.fcqDeleteIdx = 0;
        this.virtualMerkleAccountDeleteIdx = 0;
        this.cryptoCounter = 0;
        this.fcqCounter = 0;
        this.virtualMerkleAccountCounter = 0;
        this.largestInExpectedMap = new AtomicLong(0L);
    }

    private void updateEntityCounter(TransactionType transactionType, EntityType entityType) {
        switch (entityType) {
            case Crypto: {
                if (transactionType == TransactionType.Create) {
                    ++this.cryptoCounter;
                    break;
                }
                if (transactionType != TransactionType.Delete) break;
                --this.cryptoCounter;
                break;
            }
            case FCQ: {
                if (transactionType == TransactionType.Create) {
                    ++this.fcqCounter;
                    break;
                }
                if (transactionType != TransactionType.Delete) break;
                --this.fcqCounter;
                break;
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                if (transactionType == TransactionType.Create) {
                    ++this.virtualMerkleAccountCounter;
                    break;
                }
                if (transactionType != TransactionType.Delete) break;
                --this.virtualMerkleAccountCounter;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
            }
        }
    }

    private int getEntityCounter(EntityType entityType) {
        switch (entityType) {
            case Crypto: {
                return this.cryptoCounter;
            }
            case FCQ: {
                return this.fcqCounter;
            }
        }
        throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
    }

    private void initExpectedMap(boolean isRestart) {
        int expectedMapCapacity = this.getExpectedMapInitCapacity();
        if (isRestart) {
            expectedMapCapacity += this.cryptoCounter + this.fcqCounter + this.virtualMerkleAccountCounter;
        }
        this.expectedMap = new ConcurrentHashMap<MapKey, ExpectedValue>(expectedMapCapacity);
        logger.info(DEMO_INFO, "Set ExpectedMap initial capacity to be: {}", (Object)expectedMapCapacity);
    }

    private void initEntityListCapacity(EntityType entityType, boolean isRestart) {
        int selfListCapacity;
        int listCapacity;
        String entityDescription;
        switch (entityType) {
            case Crypto: {
                entityDescription = "account";
                listCapacity = this.getEntityListInitCapacity(EntityType.Crypto) + (isRestart ? this.cryptoCounter : 0);
                this.accountList = Collections.synchronizedList(new ArrayList(listCapacity));
                selfListCapacity = this.calculateSelfListCapacity(listCapacity);
                this.accountSelfEntitiesList = Collections.synchronizedList(new ArrayList(selfListCapacity));
                break;
            }
            case FCQ: {
                entityDescription = "fcq";
                listCapacity = this.getEntityListInitCapacity(EntityType.FCQ) + (isRestart ? this.fcqCounter : 0);
                this.fcqList = Collections.synchronizedList(new ArrayList(listCapacity));
                selfListCapacity = this.calculateSelfListCapacity(listCapacity);
                this.fcqSelfEntitiesList = Collections.synchronizedList(new ArrayList(selfListCapacity));
                break;
            }
            case VIRTUAL_MERKLE_ACCOUNT: {
                entityDescription = "virtual-merkle-account";
                listCapacity = this.getEntityListInitCapacity(EntityType.VIRTUAL_MERKLE_ACCOUNT) + (isRestart ? this.virtualMerkleAccountCounter : 0);
                this.virtualMerkleAccountList = Collections.synchronizedList(new ArrayList(listCapacity));
                selfListCapacity = this.calculateSelfListCapacity(listCapacity);
                this.virtualMerkleAccountSelfEntitiesList = Collections.synchronizedList(new ArrayList(selfListCapacity));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
            }
        }
        logger.info(DEMO_INFO, "Set {}List initial capacity to be: {}", (Object)entityDescription, (Object)listCapacity);
        logger.info(DEMO_INFO, "Set {}SelfEntitiesList initial capacity to be: {}", (Object)entityDescription, (Object)selfListCapacity);
    }

    int calculateSelfListCapacity(int listCapacity) {
        return (int)Math.ceil((double)listCapacity / (double)Math.max(this.weightedNodeNum, 1));
    }

    @Override
    public MapKey getMapKeyForQuery(EntityType entityType) throws IllegalArgumentException {
        List<MapKey> entityList = switch (entityType) {
            case EntityType.Crypto -> this.accountList;
            case EntityType.FCQ -> this.fcqList;
            case EntityType.VIRTUAL_MERKLE_ACCOUNT -> this.virtualMerkleAccountList;
            default -> throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
        };
        if (entityList.isEmpty()) {
            return new MapKey(0L, 0L, 0L);
        }
        return entityList.get(ThreadLocalRandom.current().nextInt(entityList.size()));
    }
}

