/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import com.swirlds.logging.api.internal.format.ShrinkableSizeCache;
import com.swirlds.logging.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.stream.IntStream;

public class EpochCachedFormatter {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter().withZone(ZoneOffset.UTC);
    private final Map<Instant, String> exactCache = new ShrinkableSizeCache<Instant, String>(1);
    private final Map<Instant, String> dateCache = new ShrinkableSizeCache<Instant, String>(10);
    private static final String[] TWO_SPACE_DIGITS_CACHE = (String[])IntStream.range(0, 60).mapToObj(i -> StringUtils.toPaddedDigitsString(i, 2)).toArray(String[]::new);
    private static final String[] THREE_SPACE_DIGITS_CACHE = (String[])IntStream.range(0, 1000).mapToObj(i -> StringUtils.toPaddedDigitsString(i, 3)).toArray(String[]::new);

    public EpochCachedFormatter() {
        this.format(System.currentTimeMillis());
    }

    @NonNull
    public String format(long epochMillis) {
        Instant instant = Instant.ofEpochMilli(epochMillis);
        String stringDate = this.exactCache.get(instant);
        if (stringDate == null) {
            stringDate = this.getFromDate(instant);
        }
        if (stringDate == null) {
            stringDate = this.getFromFormatter(instant);
        }
        return stringDate;
    }

    @NonNull
    private String getFromFormatter(@NonNull Instant instant) {
        String stringDate = FORMATTER.format(instant);
        this.exactCache.put(instant, stringDate);
        this.dateCache.put(instant.truncatedTo(ChronoUnit.DAYS), stringDate.substring(0, 11));
        return stringDate;
    }

    @Nullable
    private String getFromDate(@NonNull Instant instant) {
        String format = this.dateCache.get(instant.truncatedTo(ChronoUnit.DAYS));
        if (format == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(format);
        long totalSeconds = instant.getEpochSecond();
        int hour = (int)(totalSeconds / 3600L % 24L);
        buffer.append(TWO_SPACE_DIGITS_CACHE[hour]);
        buffer.append(":");
        int minute = (int)(totalSeconds / 60L % 60L);
        buffer.append(TWO_SPACE_DIGITS_CACHE[minute]);
        buffer.append(":");
        int second = (int)(totalSeconds % 60L);
        buffer.append(TWO_SPACE_DIGITS_CACHE[second]);
        buffer.append(".");
        int milliseconds = instant.getNano() / 1000000;
        buffer.append(THREE_SPACE_DIGITS_CACHE[milliseconds]);
        String stringDate = buffer.toString();
        this.exactCache.put(instant, stringDate);
        return stringDate;
    }
}

