/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConcurrentBlockingIterator<T>
implements Iterator<T> {
    private final LinkedBlockingQueue<T> buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private T next;

    public ConcurrentBlockingIterator(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        this.buffer = new LinkedBlockingQueue(bufferSize);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            boolean isOpen;
            boolean bl = isOpen = !this.closed.get();
            while ((this.next = this.buffer.poll(10L, TimeUnit.MILLISECONDS)) == null && isOpen) {
                isOpen = !this.closed.get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Concurrent iterator is interrupted", e);
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.next != null) : "Unexpected null next";
        T ret = this.next;
        this.next = null;
        return ret;
    }

    public void supply(T element) throws InterruptedException {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot supply elements to a closed ConcurrentBlockingIterator");
        }
        Objects.requireNonNull(element);
        this.buffer.put(element);
    }

    public void close() {
        this.closed.set(true);
    }
}

