/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.stream;

import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.test.fixtures.stream.ObjectForTestStream;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.RunningHash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class WriteToStreamConsumer
implements LinkedObjectStream<ObjectForTestStream> {
    private static final Logger logger = LogManager.getLogger(WriteToStreamConsumer.class);
    private static final Marker LOGM_OBJECT_STREAM = MarkerManager.getMarker((String)"OBJECT_STREAM");
    private static final Marker LOGM_EXCEPTION = MarkerManager.getMarker((String)"EXCEPTION");
    private SerializableDataOutputStream outputStream;
    private RunningHash runningHash;
    public boolean isClosed = false;
    public int consumedCount = 0;

    public WriteToStreamConsumer(SerializableDataOutputStream stream, Hash startRunningHash) throws IOException {
        this.outputStream = stream;
        try {
            this.outputStream.writeSerializable((SelfSerializable)startRunningHash, true);
        }
        catch (IOException ex) {
            throw new IOException(String.format("Failed to write startRunningHash: %s. IOException: %s", startRunningHash, ex.getMessage()), ex.getCause());
        }
        logger.info(LOGM_OBJECT_STREAM, "Wrote startRunningHash: {}", (Object)startRunningHash);
    }

    public void addObject(ObjectForTestStream object) {
        try {
            this.outputStream.writeSerializable((SelfSerializable)object, true);
            logger.info(LOGM_OBJECT_STREAM, "write object: {}", (Object)object);
            this.runningHash = object.getRunningHash();
            ++this.consumedCount;
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to add object", (Throwable)ex);
        }
    }

    public void close() {
        try {
            this.outputStream.writeSerializable((SelfSerializable)this.runningHash.getFutureHash().getAndRethrow(), true);
            logger.info(LOGM_OBJECT_STREAM, "Wrote endRunningHash: {}", (Object)this.runningHash);
            this.outputStream.close();
            this.isClosed = true;
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to close output stream", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void clear() {
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to close output stream", (Throwable)ex);
        }
    }

    public void setRunningHash(Hash hash) {
        this.runningHash = new RunningHash(hash);
    }
}

