/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.virtualmap.VirtualKey;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class OnDiskKey<K>
implements VirtualKey {
    @Deprecated(forRemoval=true)
    private static final long CLASS_ID = 2965940873328141171L;
    static final int VERSION = 1;
    private final Codec<K> codec;
    private final Long classId;
    private K key;

    @Deprecated(forRemoval=true)
    public OnDiskKey() {
        this.classId = 2965940873328141171L;
        this.codec = null;
    }

    public OnDiskKey(long classId, @Nullable Codec<K> codec) {
        this.classId = classId;
        this.codec = codec;
    }

    public OnDiskKey(long classId, @Nullable Codec<K> codec, @NonNull K key) {
        this(classId, codec);
        this.key = Objects.requireNonNull(key);
    }

    @NonNull
    public K getKey() {
        return this.key;
    }

    public long getClassId() {
        return this.classId;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        if (this.codec == null) {
            throw new IllegalStateException("Cannot serialize on-disk key, null metadata / codec");
        }
        StateUtils.writeToStream((OutputStream)out, this.codec, this.key);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int ignored) throws IOException {
        if (this.codec == null) {
            throw new IllegalStateException("Cannot deserialize on-disk key, null metadata / codec");
        }
        this.key = StateUtils.readFromStream((InputStream)in, this.codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OnDiskKey)) {
            return false;
        }
        OnDiskKey onDiskKey = (OnDiskKey)o;
        return Objects.equals(this.key, onDiskKey.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return "OnDiskKey{key=" + String.valueOf(this.key) + "}";
    }
}

