/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.lifecycle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import java.io.Serializable;
import java.util.Objects;
import org.hiero.base.crypto.Hash;

public class ExpectedValue
implements Serializable {
    @JsonProperty
    private EntityType entityType;
    @JsonProperty
    private Hash hash;
    @JsonProperty
    private boolean isErrored;
    @JsonProperty
    private LifecycleStatus latestHandledStatus;
    @JsonProperty
    private LifecycleStatus latestSubmitStatus;
    @JsonProperty
    private LifecycleStatus historyHandledStatus;
    @JsonProperty
    private long uid;

    public ExpectedValue(EntityType entityType, Hash hash, boolean isErrored, LifecycleStatus latestSubmitStatus, LifecycleStatus latestHandledStatus, LifecycleStatus historyHandledStatus, long uid) {
        this.entityType = entityType;
        this.hash = hash;
        this.isErrored = isErrored;
        this.latestSubmitStatus = latestSubmitStatus;
        this.latestHandledStatus = latestHandledStatus;
        this.historyHandledStatus = historyHandledStatus;
        this.uid = uid;
    }

    public ExpectedValue(EntityType entityType, LifecycleStatus latestSubmitStatus) {
        this.entityType = entityType;
        this.hash = null;
        this.isErrored = false;
        this.latestHandledStatus = null;
        this.latestSubmitStatus = latestSubmitStatus;
        this.historyHandledStatus = null;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public ExpectedValue() {
    }

    public Hash getHash() {
        return this.hash;
    }

    public ExpectedValue setHash(Hash hash) {
        this.hash = hash;
        return this;
    }

    @JsonIgnore
    public boolean isErrored() {
        return this.isErrored;
    }

    public ExpectedValue setErrored(boolean errored) {
        this.isErrored = errored;
        return this;
    }

    public LifecycleStatus getLatestHandledStatus() {
        return this.latestHandledStatus;
    }

    public ExpectedValue setLatestHandledStatus(LifecycleStatus latestHandledStatus) {
        this.latestHandledStatus = latestHandledStatus;
        return this;
    }

    public LifecycleStatus getLatestSubmitStatus() {
        return this.latestSubmitStatus;
    }

    public ExpectedValue setLatestSubmitStatus(LifecycleStatus latestSubmitStatus) {
        this.latestSubmitStatus = latestSubmitStatus;
        return this;
    }

    public LifecycleStatus getHistoryHandledStatus() {
        return this.historyHandledStatus;
    }

    public ExpectedValue setHistoryHandledStatus(LifecycleStatus historyHandledStatus) {
        this.historyHandledStatus = historyHandledStatus;
        return this;
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public boolean isHashMatch(MapValue mapValue) {
        return this.hash.equals((Object)mapValue.getHash());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityType, this.hash, this.isErrored, this.latestHandledStatus, this.latestSubmitStatus, this.historyHandledStatus});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExpectedValue that = (ExpectedValue)other;
        return this.isErrored == that.isErrored && this.entityType == that.entityType && Objects.equals(this.hash, that.hash) && Objects.equals(this.latestHandledStatus, that.latestHandledStatus) && Objects.equals(this.latestSubmitStatus, that.latestSubmitStatus) && Objects.equals(this.historyHandledStatus, that.historyHandledStatus);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("EntityType", (Object)this.entityType).append("Hash", (Object)this.hash).append("isErrored", (Object)this.isErrored).append("latestHandledStatus", (Object)this.latestHandledStatus).append("latestSubmitStatus", (Object)this.latestSubmitStatus).append("historyHandledStatus", (Object)this.historyHandledStatus).toString();
    }

    public boolean isHandleRejected() {
        return this.latestHandledStatus != null && this.latestHandledStatus.getTransactionState() == TransactionState.HANDLE_REJECTED;
    }
}

