/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map.internal;

import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_CATEGORY;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.system.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ExpectedMapUtils {
    private static final Logger logger = LogManager.getLogger(ExpectedMapUtils.class);
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");

    public static void buildExpectedMapAfterReconnect(ReconnectCompleteNotification notification, Platform platform) {
        if (notification.getState() == null) {
            logger.info(ERROR, "received state is null, so do not rebuildExpectedMap after reconnect");
            return;
        }
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            state.rebuildExpectedMapFromState(notification.getConsensusTimestamp(), false);
        }
    }

    public static void modifySubmitStatus(PlatformTestingToolState state, boolean isSuccess, boolean isActive, Triple<byte[], PAYLOAD_TYPE, MapKey> submittedPayloadTriple, PayloadConfig payloadConfig) {
        LifecycleStatus latestSubmitStatus;
        if (!isActive || state == null) {
            return;
        }
        ExpectedFCMFamily expectedFCMFamily = state.getStateExpectedMap();
        MapKey key = submittedPayloadTriple.right();
        if (key == null) {
            return;
        }
        PAYLOAD_TYPE payload_type = submittedPayloadTriple.middle();
        if (payload_type == PAYLOAD_TYPE.TYPE_MINT_TOKEN || payload_type == PAYLOAD_TYPE.TYPE_BURN_TOKEN || payload_type == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE || payload_type == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_UPDATE || payload_type == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_DELETE || payload_type == PAYLOAD_TYPE.TYPE_TRANSFER_TOKEN) {
            return;
        }
        ExpectedValue value = expectedFCMFamily.getExpectedMap().get(key);
        if (value == null) {
            if (payload_type.getPayloadCategory() == PAYLOAD_CATEGORY.CATEGORY_VIRTUAL_MERKLE) {
                return;
            }
            boolean isEntityInserted = expectedFCMFamily.insertMissingEntity(submittedPayloadTriple.left(), expectedFCMFamily, key, payloadConfig);
            if (!isEntityInserted) {
                return;
            }
        }
        if ((latestSubmitStatus = (value = expectedFCMFamily.getExpectedMap().get(key)).getLatestSubmitStatus()) == null) {
            LifecycleStatus status = expectedFCMFamily.buildLifecycleStatusFromPayload(submittedPayloadTriple.left(), payloadConfig);
            value.setLatestSubmitStatus(status);
        }
        TransactionState transactionstate = isSuccess ? TransactionState.SUBMITTED : TransactionState.SUBMISSION_FAILED;
        value.getLatestSubmitStatus().setTransactionState(transactionstate);
        expectedFCMFamily.getExpectedMap().put(key, value);
    }
}

