/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.gui;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.Randotron;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.event.source.ForkingEventSource;
import com.swirlds.platform.test.fixtures.event.source.StandardEventSource;
import com.swirlds.platform.test.fixtures.gui.GeneratorEventProvider;
import com.swirlds.platform.test.fixtures.gui.TestGuiSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class HashgraphGui {
    public static void main(String[] args) {
        Randotron randotron = Randotron.create((long)1L);
        int numNodes = 4;
        int initialEvents = 50;
        PlatformContext platformContext = TestPlatformContextBuilder.create().build();
        StandardGraphGenerator graphGenerator = new StandardGraphGenerator(platformContext, (long)randotron.nextInt(), HashgraphGui.generateSources(4, Arrays.stream(args).anyMatch("branch"::equals)));
        graphGenerator.reset();
        TestGuiSource guiSource = new TestGuiSource(platformContext, graphGenerator.getAddressBook(), new GeneratorEventProvider(graphGenerator));
        guiSource.generateEvents(50);
        guiSource.runGui();
    }

    @NonNull
    private static List<EventSource> generateSources(int numNetworkNodes, boolean shouldBranch) {
        LinkedList<EventSource> list = new LinkedList<EventSource>();
        for (long i = 0L; i < (long)numNetworkNodes; ++i) {
            if (i == 1L && shouldBranch) {
                list.add(new ForkingEventSource().setForkProbability(0.8).setMaximumBranchCount(5));
                continue;
            }
            list.add(new StandardEventSource(true));
        }
        return list;
    }
}

