/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.stale;

import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import org.hiero.consensus.model.event.PlatformEvent;

public class StaleEventDetectorMetrics {
    private static final LongAccumulator.Config STALE_EVENTS_CONFIG = new LongAccumulator.Config("internal", "staleEvents").withAccumulator(Long::sum).withDescription("number of stale self events");
    private final LongAccumulator staleEventCount;
    private static final LongAccumulator.Config STALE_APP_TRANSACTIONS_CONFIG = new LongAccumulator.Config("internal", "staleAppTransactions").withAccumulator(Long::sum).withDescription("number of application transactions in stale self events");
    private final LongAccumulator staleAppTransactionCount;

    public StaleEventDetectorMetrics(@NonNull Metrics metrics) {
        this.staleEventCount = (LongAccumulator)metrics.getOrCreate((MetricConfig)STALE_EVENTS_CONFIG);
        this.staleAppTransactionCount = (LongAccumulator)metrics.getOrCreate((MetricConfig)STALE_APP_TRANSACTIONS_CONFIG);
    }

    public void reportStaleEvent(@NonNull PlatformEvent event) {
        int appTransactions = 0;
        Iterator iterator = event.transactionIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++appTransactions;
        }
        this.staleEventCount.update(1L);
        this.staleAppTransactionCount.update((long)appTransactions);
    }
}

