/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YamlConfigSource
implements ConfigSource {
    private static final Logger logger = LogManager.getLogger(YamlConfigSource.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Map<String, String> properties;
    private final Map<String, List<String>> listProperties;
    private final int ordinal;

    public YamlConfigSource(@NonNull String fileName) {
        this(fileName, 100);
    }

    public YamlConfigSource(@NonNull String fileName, int ordinal) {
        Objects.requireNonNull(fileName, "fileName must not be null");
        this.properties = new HashMap<String, String>();
        this.listProperties = new HashMap<String, List<String>>();
        this.ordinal = ordinal;
        try (InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            if (resource == null) {
                throw new UncheckedIOException(new IOException("Resource not found: " + fileName));
            }
            this.processYamlFile(resource);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read YAML file " + fileName, e);
        }
    }

    public YamlConfigSource(@NonNull Path filePath) {
        this(filePath, 100);
    }

    public YamlConfigSource(@NonNull Path filePath, int ordinal) {
        Objects.requireNonNull(filePath, "filePath must not be null");
        this.properties = new HashMap<String, String>();
        this.listProperties = new HashMap<String, List<String>>();
        this.ordinal = ordinal;
        if (!Files.exists(filePath, new LinkOption[0])) {
            logger.warn("File {} does not exist, no properties will be loaded", (Object)filePath);
            return;
        }
        try (InputStream resource = Files.newInputStream(filePath, new OpenOption[0]);){
            this.processYamlFile(resource);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read YAML file " + String.valueOf(filePath), e);
        }
    }

    private void processYamlFile(@NonNull InputStream resource) throws IOException {
        Objects.requireNonNull(resource, "resource must not be null");
        JsonNode rootNode = YAML_MAPPER.readTree(resource);
        if (!rootNode.isObject()) {
            throw new IllegalArgumentException("Root YAML node must be an object");
        }
        rootNode.fields().forEachRemaining(configEntry -> {
            String configName = (String)configEntry.getKey();
            JsonNode configNode = (JsonNode)configEntry.getValue();
            if (!configNode.isObject()) {
                throw new IllegalArgumentException("Config section '" + configName + "' must be an object");
            }
            configNode.fields().forEachRemaining(propertyEntry -> {
                String propertyName = configName + "." + (String)propertyEntry.getKey();
                JsonNode propertyValue = (JsonNode)propertyEntry.getValue();
                if (propertyValue.isArray()) {
                    List<String> values = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyValue.elements(), 0), false).map(this::toValueString).toList();
                    this.listProperties.put(propertyName, values);
                } else {
                    this.properties.put(propertyName, this.toValueString(propertyValue));
                }
            });
        });
    }

    private String toValueString(@NonNull JsonNode node) {
        if (node.isValueNode()) {
            return node.asText();
        }
        return node.toString();
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return Stream.concat(this.properties.keySet().stream(), this.listProperties.keySet().stream()).collect(Collectors.toSet());
    }

    @Nullable
    public String getValue(@NonNull String propertyName) throws NoSuchElementException {
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        if (this.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is a list property");
        }
        return this.properties.get(propertyName);
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        return this.listProperties.containsKey(propertyName);
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        if (!this.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is not a list property");
        }
        return this.listProperties.get(propertyName);
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

