/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.pool;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.pool.TransactionPool;
import org.hiero.consensus.event.creator.impl.pool.TransactionPoolNexus;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultTransactionPool
implements TransactionPool {
    private final TransactionPoolNexus transactionPoolNexus;

    public DefaultTransactionPool(@NonNull TransactionPoolNexus transactionPoolNexus) {
        this.transactionPoolNexus = Objects.requireNonNull(transactionPoolNexus);
    }

    @Override
    public void submitSystemTransaction(@NonNull Bytes payload) {
        Objects.requireNonNull(payload);
        this.transactionPoolNexus.submitTransaction(payload, true);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        Objects.requireNonNull(platformStatus);
        this.transactionPoolNexus.updatePlatformStatus(platformStatus);
    }

    @Override
    public void reportUnhealthyDuration(@NonNull Duration duration) {
        Objects.requireNonNull(duration);
        this.transactionPoolNexus.reportUnhealthyDuration(duration);
    }

    @Override
    public void clear() {
        this.transactionPoolNexus.clear();
    }
}

