/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamFile;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RecordStreamFileJsonCodec
implements JsonCodec<RecordStreamFile> {
    @NonNull
    public RecordStreamFile parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            SemanticVersion temp_hapi_proto_version = null;
            HashObject temp_start_object_running_hash = null;
            List temp_record_stream_items = Collections.emptyList();
            HashObject temp_end_object_running_hash = null;
            long temp_block_number = 0L;
            List temp_sidecars = Collections.emptyList();
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "hapiProtoVersion": {
                        temp_hapi_proto_version = (SemanticVersion)SemanticVersion.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "startObjectRunningHash": {
                        temp_start_object_running_hash = (HashObject)HashObject.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "recordStreamItems": {
                        temp_record_stream_items = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), RecordStreamItem.JSON, (int)(maxDepth - 1));
                        continue block18;
                    }
                    case "endObjectRunningHash": {
                        temp_end_object_running_hash = (HashObject)HashObject.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "blockNumber": {
                        temp_block_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "sidecars": {
                        temp_sidecars = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), SidecarMetadata.JSON, (int)(maxDepth - 1));
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RecordStreamFile(temp_hapi_proto_version, temp_start_object_running_hash, temp_record_stream_items, temp_end_object_running_hash, temp_block_number, temp_sidecars);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RecordStreamFile data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.hapiProtoVersion() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"hapiProtoVersion", SemanticVersion.JSON, (Object)data.hapiProtoVersion()));
        }
        if (data.startObjectRunningHash() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"startObjectRunningHash", HashObject.JSON, (Object)data.startObjectRunningHash()));
        }
        if (!data.recordStreamItems().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"recordStreamItems", RecordStreamItem.JSON, data.recordStreamItems()));
        }
        if (data.endObjectRunningHash() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"endObjectRunningHash", HashObject.JSON, (Object)data.endObjectRunningHash()));
        }
        if (data.blockNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"blockNumber", (long)data.blockNumber()));
        }
        if (!data.sidecars().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"sidecars", SidecarMetadata.JSON, data.sidecars()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

