/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class BufferedOutputStream
extends OutputStream {
    private final ByteBuffer buffer;
    private final OutputStream outputStream;

    public BufferedOutputStream(@NonNull OutputStream outputStream, int bufferCapacity) {
        if (bufferCapacity <= 0) {
            throw new IllegalArgumentException("bufferCapacity must be > than 0");
        }
        this.outputStream = Objects.requireNonNull(outputStream, "outputStream must not be null");
        this.buffer = ByteBuffer.wrap(new byte[bufferCapacity]);
    }

    @Override
    public synchronized void write(@NonNull byte[] bytes, int offset, int length) throws IOException {
        this.internalWrite(bytes, offset, length);
    }

    @Override
    public synchronized void write(@NonNull byte[] bytes) throws IOException {
        this.internalWrite(bytes, 0, bytes.length);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.buffer.remaining() >= 1) {
            this.buffer.put((byte)b);
        } else {
            this.flush();
            this.outputStream.write(b);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer(this.buffer);
        this.flushDestination();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outputStream.close();
    }

    private void internalWrite(@NonNull byte[] bytes, int offset, int length) throws IOException {
        if (length >= this.buffer.capacity()) {
            this.flush();
            this.writeToDestination(bytes, offset, length);
        } else {
            if (length > this.buffer.remaining()) {
                this.flush();
            }
            this.buffer.put(bytes, offset, length);
        }
    }

    private void writeToDestination(byte[] bytes, int offset, int length) throws IOException {
        this.outputStream.write(bytes, offset, length);
    }

    private void flushDestination() throws IOException {
        this.outputStream.flush();
    }

    private void flushBuffer(ByteBuffer buf) throws IOException {
        buf.flip();
        try {
            if (buf.remaining() > 0) {
                this.writeToDestination(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            }
        }
        finally {
            buf.clear();
        }
    }
}

