/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;

public abstract class AbstractDistributionMetric
extends AbstractMetric {
    protected final double halfLife;

    protected AbstractDistributionMetric(@NonNull MetricConfig<?, ?> config, double halfLife) {
        super(config);
        this.halfLife = halfLife;
    }

    @NonNull
    public abstract StatsBuffered getStatsBuffered();

    public abstract double get();

    public double getHalfLife() {
        return this.halfLife;
    }

    @NonNull
    public Double get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        return switch (valueType) {
            case Metric.ValueType.VALUE -> this.get();
            case Metric.ValueType.MAX -> this.getStatsBuffered().getMax();
            case Metric.ValueType.MIN -> this.getStatsBuffered().getMin();
            case Metric.ValueType.STD_DEV -> this.getStatsBuffered().getStdDev();
            default -> throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf(valueType));
        };
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        StatsBuffered statsBuffered = this.getStatsBuffered();
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()), new Snapshot.SnapshotEntry(Metric.ValueType.MAX, (Object)statsBuffered.getMax()), new Snapshot.SnapshotEntry(Metric.ValueType.MIN, (Object)statsBuffered.getMin()), new Snapshot.SnapshotEntry(Metric.ValueType.STD_DEV, (Object)statsBuffered.getStdDev()));
    }

    public void reset() {
        this.getStatsBuffered().reset(this.halfLife);
    }
}

