/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api;

import com.swirlds.base.state.Startable;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Objects;

public interface Metrics
extends Startable {
    public static final String INTERNAL_CATEGORY = "internal";
    public static final String PLATFORM_CATEGORY = "platform";
    public static final String INFO_CATEGORY = "platform:info";

    @Nullable
    public Metric getMetric(@NonNull String var1, @NonNull String var2);

    @NonNull
    public Collection<Metric> findMetricsByCategory(@NonNull String var1);

    @NonNull
    public Collection<Metric> getAll();

    @Nullable
    default public Object getValue(@NonNull String category, @NonNull String name) {
        Objects.requireNonNull(category, "category must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Metric metric = this.getMetric(category, name);
        return metric != null ? metric.get(Metric.ValueType.VALUE) : null;
    }

    default public void resetAll() {
        for (Metric metric : this.getAll()) {
            metric.reset();
        }
    }

    @NonNull
    public <T extends Metric> T getOrCreate(@NonNull MetricConfig<T, ?> var1);

    public void remove(@NonNull String var1, @NonNull String var2);

    public void remove(@NonNull Metric var1);

    public void remove(@NonNull MetricConfig<?, ?> var1);

    public void addUpdater(@NonNull Runnable var1);

    public void removeUpdater(@NonNull Runnable var1);
}

