/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.hashgraph;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hiero.base.iterator.TypedIterator;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.transaction.Transaction;

public class ConsensusRound
implements Round {
    private final List<PlatformEvent> consensusEvents;
    private final List<CesEvent> streamedEvents;
    private final EventWindow eventWindow;
    private int numAppTransactions = 0;
    private final ConsensusSnapshot snapshot;
    private final Roster consensusRoster;
    private final boolean pcesRound;
    private final Instant reachedConsTimestamp;

    public ConsensusRound(@NonNull Roster consensusRoster, @NonNull List<PlatformEvent> consensusEvents, @NonNull EventWindow eventWindow, @NonNull ConsensusSnapshot snapshot, boolean pcesRound, @NonNull Instant reachedConsTimestamp) {
        this.consensusRoster = Objects.requireNonNull(consensusRoster);
        this.consensusEvents = Collections.unmodifiableList(Objects.requireNonNull(consensusEvents));
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.snapshot = Objects.requireNonNull(snapshot);
        this.pcesRound = pcesRound;
        this.reachedConsTimestamp = Objects.requireNonNull(reachedConsTimestamp);
        this.streamedEvents = new ArrayList<CesEvent>(consensusEvents.size());
        Iterator<PlatformEvent> iterator = consensusEvents.iterator();
        while (iterator.hasNext()) {
            PlatformEvent e = iterator.next();
            Iterator<Transaction> ti = e.transactionIterator();
            while (ti.hasNext()) {
                ti.next();
                ++this.numAppTransactions;
            }
            this.streamedEvents.add(new CesEvent(e, snapshot.round(), !iterator.hasNext()));
        }
    }

    public int getNumAppTransactions() {
        return this.numAppTransactions;
    }

    @NonNull
    public List<PlatformEvent> getConsensusEvents() {
        return this.consensusEvents;
    }

    @NonNull
    public List<CesEvent> getStreamedEvents() {
        return this.streamedEvents;
    }

    @NonNull
    public EventWindow getEventWindow() {
        return this.eventWindow;
    }

    @NonNull
    public ConsensusSnapshot getSnapshot() {
        return this.snapshot;
    }

    public int getNumEvents() {
        return this.consensusEvents.size();
    }

    @Override
    @NonNull
    public Iterator<ConsensusEvent> iterator() {
        return new TypedIterator(this.consensusEvents.iterator());
    }

    @Override
    public long getRoundNum() {
        return this.snapshot.round();
    }

    @Override
    public boolean isEmpty() {
        return this.consensusEvents.isEmpty();
    }

    @Override
    public int getEventCount() {
        return this.consensusEvents.size();
    }

    @Override
    @NonNull
    public Roster getConsensusRoster() {
        return this.consensusRoster;
    }

    @Override
    @NonNull
    public Instant getConsensusTimestamp() {
        return Objects.requireNonNull(CommonUtils.fromPbjTimestamp((Timestamp)this.snapshot.consensusTimestamp()));
    }

    @NonNull
    public Instant getReachedConsTimestamp() {
        return this.reachedConsTimestamp;
    }

    public boolean isPcesRound() {
        return this.pcesRound;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConsensusRound that = (ConsensusRound)other;
        return Objects.equals(this.consensusEvents, that.consensusEvents);
    }

    public int hashCode() {
        return Objects.hash(this.consensusEvents);
    }

    public String toString() {
        String eventStrings = this.consensusEvents.stream().map(event -> event.getDescriptor().toString()).collect(Collectors.joining(","));
        return new ToStringBuilder((Object)this).append("round", (Object)this.snapshot.round()).append("consensus events", (Object)eventStrings).toString();
    }
}

