/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.base.utility.AutoCloseableNonThrowing;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateHistory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.exceptions.ReferenceCountException;

public class ReservedSignedState
implements AutoCloseableNonThrowing {
    private static final Logger logger = LogManager.getLogger(ReservedSignedState.class);
    private static final AtomicLong nextReservationId = new AtomicLong(0L);
    private final SignedState signedState;
    private final String reason;
    private final long reservationId;
    private boolean closed = false;

    @NonNull
    public static ReservedSignedState createNullReservation() {
        return new ReservedSignedState();
    }

    private ReservedSignedState() {
        this.signedState = null;
        this.reason = "";
        this.reservationId = nextReservationId.getAndIncrement();
    }

    private ReservedSignedState(@NonNull SignedState signedState, @NonNull String reason, long reservationId) {
        this.signedState = Objects.requireNonNull(signedState);
        this.reason = Objects.requireNonNull(reason);
        this.reservationId = reservationId;
    }

    @NonNull
    static ReservedSignedState createAndReserve(@NonNull SignedState signedState, @NonNull String reason) {
        ReservedSignedState reservedSignedState = new ReservedSignedState(signedState, reason, nextReservationId.getAndIncrement());
        signedState.incrementReservationCount(reason, reservedSignedState.getReservationId());
        return reservedSignedState;
    }

    public boolean isNull() {
        this.throwIfClosed();
        return this.signedState == null;
    }

    public boolean isNotNull() {
        this.throwIfClosed();
        return this.signedState != null;
    }

    @NonNull
    public ReservedSignedState getAndReserve(@NonNull String reason) {
        this.throwIfClosed();
        if (this.signedState == null) {
            return new ReservedSignedState();
        }
        return ReservedSignedState.createAndReserve(this.signedState, reason);
    }

    @Nullable
    public ReservedSignedState tryGetAndReserve(@NonNull String reason) {
        if (this.signedState == null) {
            return new ReservedSignedState();
        }
        long reservationId = nextReservationId.getAndIncrement();
        if (!this.signedState.tryIncrementReservationCount(reason, reservationId)) {
            return null;
        }
        return new ReservedSignedState(this.signedState, reason, reservationId);
    }

    @NonNull
    public SignedState get() {
        this.throwIfClosed();
        if (this.signedState == null) {
            throw new IllegalStateException("This object wraps null, and this method is only permitted to be called if the signed state is not null.");
        }
        return Objects.requireNonNull(this.signedState);
    }

    @Nullable
    public SignedState getNullable() {
        this.throwIfClosed();
        return this.signedState;
    }

    public void close() {
        this.throwIfClosed();
        this.closed = true;
        if (this.signedState != null) {
            this.signedState.decrementReservationCount(this.reason, this.reservationId);
        }
    }

    @NonNull
    String getReason() {
        return this.reason;
    }

    long getReservationId() {
        return this.reservationId;
    }

    private void throwIfClosed() {
        if (this.closed) {
            SignedStateHistory history;
            if (this.signedState != null && (history = this.signedState.getHistory()) != null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "This ReservedSignedState has already been closed, dumping history. Reservation ID = {}, reservation reason ={}\n{},", (Object)this.reservationId, (Object)this.reason, (Object)history);
            }
            throw new ReferenceCountException("This ReservedSignedState has been closed.");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

